/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.jfin.date.Frequency;
import org.jfin.date.Initialisable;
import org.jfin.date.Period;
import org.jfin.date.ScheduleException;
import org.jfin.date.StubType;
import org.jfin.date.Tenor;

public class TypedScheduleGenerator<T extends Period> {
    private T prototype;
    private int maxPeriods = -1;

    public TypedScheduleGenerator(T prototype) {
        this.prototype = prototype;
    }

    public TypedScheduleGenerator(T prototype, int maxPeriods) {
        this.prototype = prototype;
        this.maxPeriods = maxPeriods;
    }

    public T getPrototype() {
        return this.prototype;
    }

    public void setPrototype(T prototype) {
        this.prototype = prototype;
    }

    public int getMaxPeriods() {
        return this.maxPeriods;
    }

    public void setMaxPeriods(int maxPeriods) {
        this.maxPeriods = maxPeriods;
    }

    public List<T> generateSchedule(Calendar startDate, String maturityString, Frequency frequency, StubType stubType) throws ScheduleException, ParseException {
        Tenor tenor = new Tenor(maturityString);
        return this.generateSchedule(startDate, tenor, frequency, stubType);
    }

    public List<T> generateSchedule(Calendar startDate, Tenor tenor, Frequency frequency, StubType stubType) throws ScheduleException {
        Calendar endDate = TypedScheduleGenerator.copyAndReset(startDate);
        endDate.add(tenor.getCalendarUnit(), tenor.getAmount());
        return this.generateSchedule(startDate, endDate, frequency.getPeriodAmount(), frequency.getPeriodUnit(), stubType);
    }

    public List<T> generateSchedule(Calendar startDate, Calendar endDate, Frequency frequency, StubType stubType) throws ScheduleException {
        return this.generateSchedule(startDate, endDate, frequency.getPeriodAmount(), frequency.getPeriodUnit(), stubType);
    }

    public List<T> generateSchedule(Calendar startDate, Calendar endDate, int frequencyAmount, int frequencyUnit, StubType stubType) throws ScheduleException {
        switch (stubType) {
            case LONG_FIRST: {
                return this.generateScheduleInternal(endDate, startDate, -1 * frequencyAmount, frequencyUnit, stubType);
            }
            case LONG_LAST: {
                return this.generateScheduleInternal(startDate, endDate, frequencyAmount, frequencyUnit, stubType);
            }
            case SHORT_FIRST: {
                return this.generateScheduleInternal(endDate, startDate, -1 * frequencyAmount, frequencyUnit, stubType);
            }
            case SHORT_LAST: {
                return this.generateScheduleInternal(startDate, endDate, frequencyAmount, frequencyUnit, stubType);
            }
        }
        return this.generateScheduleInternal(startDate, endDate, frequencyAmount, frequencyUnit, stubType);
    }

    private List<T> generateScheduleInternal(Calendar startDate, Calendar endDate, int frequencyAmount, int frequencyUnit, StubType stubType) throws ScheduleException {
        boolean forwards;
        startDate = TypedScheduleGenerator.copyAndReset(startDate);
        endDate = TypedScheduleGenerator.copyAndReset(endDate);
        Calendar holdDate = TypedScheduleGenerator.copyAndReset(startDate);
        ArrayList schedule = new ArrayList();
        int periodCount = 1;
        boolean finished = false;
        boolean bl = forwards = frequencyAmount > 0;
        while (!finished) {
            T period;
            Calendar nextDate1 = TypedScheduleGenerator.copyAndReset(startDate);
            nextDate1.add(frequencyUnit, periodCount * frequencyAmount);
            if (stubType.isShortStub()) {
                if (this.isBeyond(nextDate1, endDate, forwards) || this.isEqual(nextDate1, endDate)) {
                    period = this.createPeriod(holdDate, endDate, holdDate, nextDate1, forwards);
                    this.addPeriodToSchedule(schedule, period, forwards);
                    finished = true;
                } else {
                    period = this.createPeriod(holdDate, nextDate1, holdDate, nextDate1, forwards);
                    this.addPeriodToSchedule(schedule, period, forwards);
                }
            } else if (stubType.isLongStub()) {
                T period2;
                Calendar nextDate2 = TypedScheduleGenerator.copyAndReset(startDate);
                nextDate2.add(frequencyUnit, (periodCount + 1) * frequencyAmount);
                if (this.isBeyond(nextDate2, endDate, forwards)) {
                    period2 = this.createPeriod(holdDate, endDate, nextDate1, nextDate2, forwards);
                    this.addPeriodToSchedule(schedule, period2, forwards);
                    finished = true;
                } else {
                    period2 = this.createPeriod(holdDate, nextDate1, holdDate, nextDate1, forwards);
                    this.addPeriodToSchedule(schedule, period2, forwards);
                }
            } else {
                if (this.isBeyond(nextDate1, endDate, forwards)) {
                    throw new ScheduleException("StubType.NONE used when periods do not fit start and end date");
                }
                period = this.createPeriod(holdDate, nextDate1, holdDate, nextDate1, forwards);
                this.addPeriodToSchedule(schedule, period, forwards);
                if (this.isEqual(nextDate1, endDate)) {
                    finished = true;
                }
            }
            holdDate = TypedScheduleGenerator.copyAndReset(nextDate1);
            if (this.maxPeriods <= 0 || ++periodCount <= this.maxPeriods) continue;
            throw new ScheduleException("Maximum number of periods (" + this.maxPeriods + ") exceeded.");
        }
        return schedule;
    }

    private T createPeriod(Calendar startDate, Calendar endDate, Calendar referenceStartDate, Calendar referenceEndDate, boolean forwards) throws ScheduleException {
        T period = this.createPeriod();
        if (forwards) {
            ((Period)period).setStartCalendar(startDate);
            ((Period)period).setEndCalendar(endDate);
            ((Period)period).setReferenceStartCalendar(referenceStartDate);
            ((Period)period).setReferenceEndCalendar(referenceEndDate);
        } else {
            ((Period)period).setStartCalendar(endDate);
            ((Period)period).setEndCalendar(startDate);
            ((Period)period).setReferenceStartCalendar(referenceEndDate);
            ((Period)period).setReferenceEndCalendar(referenceStartDate);
        }
        if (period instanceof Initialisable) {
            Initialisable initialisablePeriod = (Initialisable)period;
            initialisablePeriod.initialise();
        }
        return period;
    }

    private void addPeriodToSchedule(List<T> schedule, T period, boolean forwards) {
        if (forwards) {
            schedule.add(period);
        } else {
            schedule.add(0, period);
        }
    }

    private T createPeriod() throws ScheduleException {
        if (this.prototype == null) {
            throw new ScheduleException("TypedScheduleGenerator requires a non null prototype to function.");
        }
        return (T)((Period)this.prototype).clone();
    }

    private boolean isEqual(Calendar date1, Calendar date2) {
        return !date1.after(date2) && !date1.before(date2);
    }

    private boolean isBeyond(Calendar date1, Calendar date2, boolean forwards) {
        if (forwards) {
            return date1.after(date2);
        }
        return date2.after(date1);
    }

    public static Calendar copyAndReset(Calendar calendar) {
        Calendar copy = (Calendar)calendar.clone();
        copy.set(11, 0);
        copy.set(12, 0);
        copy.set(13, 0);
        copy.set(14, 0);
        return copy;
    }
}

