/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.common.test;

import java.util.TreeMap;
import junit.framework.TestCase;
import org.jfin.common.Iso3166Country;
import org.jfin.common.Iso4217Currency;

public class Iso4217CurrencyTest
extends TestCase {
    public void testCurrencies() {
        TreeMap<String, String> currencies = new TreeMap<String, String>();
        currencies.put("AED", "UAE Dirham (United Arab Emirates)");
        currencies.put("AFN", "Afghani (Afghanistan)");
        currencies.put("ALL", "Lek (Albania)");
        currencies.put("AMD", "Armenian Dram (Armenia)");
        currencies.put("ANG", "Netherlands Antillian Guilder (Netherlands Antilles) <!--(assuming Guikder is a typo) (it surely is)-->");
        currencies.put("AOA", "Kwanza (Angola)");
        currencies.put("ARS", "Argentine Peso (Argentina)");
        currencies.put("AUD", "Australian Dollar (Australia)");
        currencies.put("AWG", "Aruban Guilder (Aruba)");
        currencies.put("AZN", "Azerbaijanian Manat (Azerbaijan)");
        currencies.put("BAM", "Convertible Marks (Bosnia and Herzegovina)");
        currencies.put("BBD", "Barbados Dollar (Barbados)");
        currencies.put("BDT", "Taka (Bangladesh)");
        currencies.put("BGN", "Bulgarian Lev (Bulgaria)");
        currencies.put("BHD", "Bahraini Dinar (Bahrain)");
        currencies.put("BIF", "Burundian Franc (Burundi)");
        currencies.put("BMD", "Bermudian Dollar (customarily known as Bermuda Dollar) (Bermuda)");
        currencies.put("BND", "Brunei Dollar (Brunei)");
        currencies.put("BOB", "Boliviano (Bolivia)");
        currencies.put("BOV", "Bolivian Mvdol (Funds code) (Bolivia)");
        currencies.put("BRL", "Brazilian Real (Brazil)");
        currencies.put("BSD", "Bahamian Dollar (Bahamas)");
        currencies.put("BTN", "Ngultrum (Bhutan)");
        currencies.put("BWP", "Pula (Botswana)");
        currencies.put("BYR", "Belarussian Ruble (Belarus)");
        currencies.put("BZD", "Belize Dollar (Belize)");
        currencies.put("CAD", "Canadian Dollar (Canada)");
        currencies.put("CDF", "Franc Congolais (Democratic Republic of Congo) ");
        currencies.put("CHF", "Swiss Franc (Switzerland)");
        currencies.put("CLF", "Unidades de formento (Funds code) (Chile)");
        currencies.put("CLP", "Chilean Peso (Chile)");
        currencies.put("CNY", "Yuan Renminbi (People's Republic of China)");
        currencies.put("COP", "Colombian Peso (Colombia)");
        currencies.put("COU", "Unidad de Valor Real (Colombia)");
        currencies.put("CRC", "Costa Rican Colon (Costa Rica)");
        currencies.put("CSD", "Serbian Dinar (Serbia)");
        currencies.put("CUP", "Cuban Peso (Cuba)");
        currencies.put("CVE", "Cape Verde Escudo (Cape Verde)");
        currencies.put("CYP", "Cyprus Pound (Cyprus)");
        currencies.put("CZK", "Czech Koruna (Czech Republic)");
        currencies.put("DJF", "Djibouti Franc (Djibouti)");
        currencies.put("DKK", "Danish Krone (Denmark, Faroe Islands)");
        currencies.put("DOP", "Dominican Peso (Dominican Republic)");
        currencies.put("DZD", "Algerian Dinar (Algeria)");
        currencies.put("EEK", "Kroon (Estonia)");
        currencies.put("EGP", "Egyptian Pound (Egypt)");
        currencies.put("ERN", "Nakfa (Eritrea)");
        currencies.put("ETB", "Ethiopian Birr (Ethiopia)");
        currencies.put("EUR", "Euro (Andorra, Austria, Belgium, Finland, France, French Guiana, French Southern Territories, Germany\t], Greece, Guadeloupe, Ireland, Italy, Luxembourg, Martinique, Mayotte, Monaco, Montenegro\t], Netherlands, Portugal, Reunion, Saint Pierre and Miquelon, San Marino, Spain, Vatican ty\t]) ");
        currencies.put("FJD", "Fiji Dollar (Fiji)");
        currencies.put("FKP", "Falkland Islands Pound (Falkland Islands)");
        currencies.put("GBP", "Pound Sterling (United Kingdom)");
        currencies.put("GEL", "Lari (Georgia (country)|Georgia)");
        currencies.put("GHC", "Cedi (Ghana)");
        currencies.put("GIP", "Gibraltar Pound (Gibraltar)");
        currencies.put("GMD", "Dalasi (Gambia)");
        currencies.put("GNF", "Guinea Franc (Guinea)");
        currencies.put("GTQ", "Guatemalan quetzal|Quetzal (Guatemala");
        currencies.put("GYD", "Guyana Dollar (Guyana)");
        currencies.put("HKD", "Hong Kong Dollar (Hong Kong)");
        currencies.put("HNL", "Lempira (Honduras)");
        currencies.put("HRK", "Croatian Kuna (Croatia)");
        currencies.put("HTG", "Haiti Gourde (Haiti)");
        currencies.put("HUF", "Forint (Hungary)");
        currencies.put("IDR", "Rupiah (Indonesia)");
        currencies.put("ILS", "New Israeli Shekel (Israel)");
        currencies.put("INR", "Indian Rupee (Bhutan, India)");
        currencies.put("IQD", "Iraqi Dinar (Iraq)");
        currencies.put("IRR", "Iranian Rial (Iran)");
        currencies.put("ISK", "Iceland Krona (Iceland)");
        currencies.put("JMD", "Jamaican Dollar (Jamaica)");
        currencies.put("JOD", "Jordanian Dinar (Jordan)");
        currencies.put("JPY", "Yen (Japan)");
        currencies.put("KES", "Kenyan Shilling (Kenya)");
        currencies.put("KGS", "Som (Kyrgyzstan)");
        currencies.put("KHR", "Riel (Cambodia)");
        currencies.put("KMF", "Comoro Franc (Comoros)");
        currencies.put("KPW", "North Korean Won (North Korea)");
        currencies.put("KRW", "Won (South Korea)");
        currencies.put("KWD", "Kuwaiti Dinar (Kuwait)");
        currencies.put("KYD", "Cayman Islands Dollar (Cayman Islands)");
        currencies.put("KZT", "Tenge (Kazakhstan)");
        currencies.put("LAK", "Kip (Laos)");
        currencies.put("LBP", "Lebanese Pound (Lebanon)");
        currencies.put("LKR", "Sri Lanka Rupee (Sri Lanka)");
        currencies.put("LRD", "Liberian Dollar (Liberia)");
        currencies.put("LSL", "Loti (Lesotho)");
        currencies.put("LTL", "Lithuanian Litas (Lithuania)");
        currencies.put("LVL", "Latvian Lats (Latvia)");
        currencies.put("LYD", "Libyan Dinar (Libya)");
        currencies.put("MAD", "Moroccan Dirham (Morocco, Western Sahara)");
        currencies.put("MDL", "Moldovan Leu (Moldova)");
        currencies.put("MGA", "Malagasy Ariary (Madagascar)");
        currencies.put("MKD", "Denar (Macedonia)");
        currencies.put("MMK", "Kyat (Myanmar)");
        currencies.put("MNT", "Tugrik (Mongolia)");
        currencies.put("MOP", "Pataca (Macau)");
        currencies.put("MRO", "Ouguiya (Mauritania)");
        currencies.put("MTL", "Maltese Lira (Malta)");
        currencies.put("MUR", "Mauritius Rupee (Mauritius)");
        currencies.put("MVR", "Rufiyaa (Maldives)");
        currencies.put("MWK", "Kwacha (Malawi)");
        currencies.put("MXN", "Mexican Peso (Mexico)");
        currencies.put("MXV", "Mexican Unidad de Inversion (UDI) (Funds code) (Mexico)");
        currencies.put("MYR", "Malaysian Ringgit (Malaysia)");
        currencies.put("MZM", "Metical (Mozambique) (assuming merical is a typo)");
        currencies.put("NAD", "Namibian Dollar (Namibia)");
        currencies.put("NGN", "Naira (Nigeria)");
        currencies.put("NIO", "Cordoba Oro (Nicaragua) ");
        currencies.put("NOK", "Norwegian Krone (Norway)");
        currencies.put("NPR", "Nepalese Rupee (Nepal)");
        currencies.put("NZD", "New Zealand Dollar (Cook Islands, New Zealand, Niue, Pitcairn, Tokelau)");
        currencies.put("OMR", "Rial Omani (Oman)");
        currencies.put("PAB", "Balboa (Panama)");
        currencies.put("PEN", "Nuevo Sol (Peru)");
        currencies.put("PGK", "Kina (Papua New Guinea)");
        currencies.put("PHP", "Philippine Peso (Philippines)");
        currencies.put("PKR", "Pakistan Rupee (Pakistan)");
        currencies.put("PLN", "Zloty (Poland)");
        currencies.put("PYG", "Guarani (Paraguay)");
        currencies.put("QAR", "Qatari Rial (Qatar)");
        currencies.put("RON", "New Leu (Romania)");
        currencies.put("RUB", "Russian Ruble (Russia)");
        currencies.put("RWF", "Rwanda Franc (Rwanda)");
        currencies.put("SAR", "Saudi Riyal (Saudi Arabia)");
        currencies.put("SBD", "Solomon Islands Dollar (Solomon Islands)");
        currencies.put("SCR", "Seychelles Rupee (Seychelles)");
        currencies.put("SDD", "Sudanese Dinar (Sudan)");
        currencies.put("SEK", "Swedish Krona (Sweden)");
        currencies.put("SGD", "Singapore Dollar (Singapore)");
        currencies.put("SHP", "Saint Helena Pound (Saint Helena)");
        currencies.put("SIT", "Tolar (Slovenia)");
        currencies.put("SKK", "Slovak Koruna (Slovakia)");
        currencies.put("SLL", "Leone (Sierra Leone)");
        currencies.put("SOS", "Somali Shilling (Somalia)");
        currencies.put("SRD", "Surinam Dollar (Suriname)");
        currencies.put("STD", "Dobra (S\u00c3\u0082\u00c2\u008bo Tom\u00c3\u0082\u00c2\u008e and Pr\u00c3\u0082\u00c2\u0092ncipe)");
        currencies.put("SYP", "Syrian Pound (Syria)");
        currencies.put("SZL", "Lilangeni (Swaziland)");
        currencies.put("THB", "Baht (Thailand)");
        currencies.put("TJS", "Somoni (Tajikistan)");
        currencies.put("TMM", "Manat (Turkmenistan)");
        currencies.put("TND", "Tunisian Dinar (Tunisia)");
        currencies.put("TOP", "Pa'anga (Tonga)");
        currencies.put("TRY", "New Turkish Lira (Turkey)");
        currencies.put("TTD", "Trinidad and Tobago Dollar (Trinidad and Tobago)");
        currencies.put("TWD", "New Taiwan Dollar (Taiwan)");
        currencies.put("TZS", "Tanzanian Shilling (Tanzania)");
        currencies.put("UAH", "Hryvnia (Ukraine)");
        currencies.put("UGX", "Uganda Shilling (Uganda)");
        currencies.put("USD", "US Dollar (American Samoa, British Indian Ocean Territory, Ecuador, El Salvador, Guam, Haiti, Marshall\tIslands, Micronesia, Northern Mariana Islands, Palau, Panama, Palau, East Timor, Turks d\tCaicos Islands, United States, Virgin Islands, Western Samoa)");
        currencies.put("UYU", "Peso Uruguayo (Uruguay)");
        currencies.put("UZS", "Uzbekistan Som (Uzbekistan)");
        currencies.put("VEB", "Bolivar (Venezuela)");
        currencies.put("VND", "Dong (Vietnam)");
        currencies.put("VUV", "Vatu (Vanuatu)");
        currencies.put("WST", "Tala (Samoa)");
        currencies.put("XAF", "CFA Franc BEAC (Cameroon, Central African Republic, Congo, Chad, Equatorial Guinea, Gabon)");
        currencies.put("XAG", "Silver (one Troy ounce)");
        currencies.put("XAU", "Gold (one Troy ounce)");
        currencies.put("XBA", "European Composite Unit (EURCO) (Bonds market unit)");
        currencies.put("XBB", "European Monetary Unit (E.M.U.-6) (Bonds market unit)");
        currencies.put("XBC", "European Unit of Account 9 (E.U.A.-9) (Bonds market unit)");
        currencies.put("XBD", "European Unit of Account 17 (E.U.A.-17) (Bonds market unit)");
        currencies.put("XCD", "East Caribbean Dollar (Anguilla, Antigua and Barbuda, Dominica, Grenada, Montserrat, Saint Kitts d\tNevis, Saint Lucia, Saint Vincent and the Grenadines)");
        currencies.put("XDR", "Special Drawing Rights (International Monetary Fund|IMF)");
        currencies.put("XFO", "Gold-franc (Special settlement currency)");
        currencies.put("XFU", "UIC franc (Special settlement currency)");
        currencies.put("XOF", "CFA Franc BCEAO (Benin, Burkina Faso, C\u00c3\u0082\u00c2\u0099te d'Ivoire, Guinea-Bissau, Mali, Niger, Senegal, Togo\t])");
        currencies.put("XPD", "Palladium (one Troy ounce)");
        currencies.put("XPF", "CFP franc (French Polynesia, New Caledonia, Wallis and Futuna)");
        currencies.put("XPT", "Platinum (one Troy ounce)");
        currencies.put("YER", "Yemeni Rial (Yemen)");
        currencies.put("ZAR", "Rand (Lesotho, Namibia, South Africa)");
        currencies.put("ZMK", "Kwacha (Zambia)");
        currencies.put("ZWD", "Zimbabwe Dollar (Zimbabwe)");
        for (String ccy : currencies.keySet()) {
            String val = (String)currencies.get(ccy);
            try {
                Iso4217Currency.valueOf(ccy);
            }
            catch (Exception e) {
                Iso4217CurrencyTest.fail((String)("Currency not found " + ccy + ": " + val));
            }
        }
    }

    public void testDEM() {
        Iso4217Currency dem = Iso4217Currency.DEM;
        Iso4217CurrencyTest.assertEquals((String)"Mark (Deutsche)", (String)dem.getFullName());
        Iso3166Country country = dem.getCountries()[0];
        Iso4217CurrencyTest.assertEquals((Object)((Object)Iso3166Country.DE), (Object)((Object)country));
        Iso4217CurrencyTest.assertEquals((Object)((Object)Iso4217Currency.EUR), (Object)((Object)dem.getReplacement()));
        Iso4217CurrencyTest.assertTrue((boolean)dem.hasBeenReplaced());
        Iso4217CurrencyTest.assertEquals((String)"Formerly DDM in east germany", (String)dem.getNotes());
    }
}

