/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.common.test;

import java.text.ParseException;
import java.util.Date;
import junit.framework.TestCase;
import org.jfin.common.CSVFileFormatTokenizer;

public class CSVFileFormatTokenizerTest
extends TestCase {
    public void testSimple1() {
        String line = "this,is,a,test";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)4, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"this", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"is", (String)tokens[1]);
        CSVFileFormatTokenizerTest.assertEquals((String)"a", (String)tokens[2]);
        CSVFileFormatTokenizerTest.assertEquals((String)"test", (String)tokens[3]);
    }

    public void testSimple2() {
        String line = ",this,is,a,test";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)5, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"this", (String)tokens[1]);
        CSVFileFormatTokenizerTest.assertEquals((String)"is", (String)tokens[2]);
        CSVFileFormatTokenizerTest.assertEquals((String)"a", (String)tokens[3]);
        CSVFileFormatTokenizerTest.assertEquals((String)"test", (String)tokens[4]);
    }

    public void testSimple3() {
        String line = ",this,,is,,,a,test";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)8, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"this", (String)tokens[1]);
        CSVFileFormatTokenizerTest.assertEquals((String)"", (String)tokens[2]);
        CSVFileFormatTokenizerTest.assertEquals((String)"is", (String)tokens[3]);
        CSVFileFormatTokenizerTest.assertEquals((String)"", (String)tokens[4]);
        CSVFileFormatTokenizerTest.assertEquals((String)"", (String)tokens[5]);
        CSVFileFormatTokenizerTest.assertEquals((String)"a", (String)tokens[6]);
        CSVFileFormatTokenizerTest.assertEquals((String)"test", (String)tokens[7]);
    }

    public void testSimple4() {
        String line = "this,is,a,test,";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)5, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"this", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"is", (String)tokens[1]);
        CSVFileFormatTokenizerTest.assertEquals((String)"a", (String)tokens[2]);
        CSVFileFormatTokenizerTest.assertEquals((String)"test", (String)tokens[3]);
        CSVFileFormatTokenizerTest.assertEquals((String)"", (String)tokens[4]);
    }

    public void testSimple5() {
        String line = "this,is,\"a\",test";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)4, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"this", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"is", (String)tokens[1]);
        CSVFileFormatTokenizerTest.assertEquals((String)"a", (String)tokens[2]);
        CSVFileFormatTokenizerTest.assertEquals((String)"test", (String)tokens[3]);
    }

    public void testSimple6() {
        String line = "this,is,\"a,test\"";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)3, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"this", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"is", (String)tokens[1]);
        CSVFileFormatTokenizerTest.assertEquals((String)"a,test", (String)tokens[2]);
    }

    public void testSimple7() {
        String line = "\"this,is\",\"a,test\"";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)2, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"this,is", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"a,test", (String)tokens[1]);
    }

    public void testSimple8() {
        String line = ",\",test\"";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)2, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)",test", (String)tokens[1]);
    }

    public void testSimple9() {
        String line = "\"\"\"a test, quote\"\" said\",the test";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)2, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"\"a test, quote\" said", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"the test", (String)tokens[1]);
    }

    public void testSimple10() {
        String line = "\"\"\"a, test, quote\"\" said\",the test";
        String[] tokens = CSVFileFormatTokenizer.getTokens(line);
        CSVFileFormatTokenizerTest.assertEquals((int)2, (int)tokens.length);
        CSVFileFormatTokenizerTest.assertEquals((String)"\"a, test, quote\" said", (String)tokens[0]);
        CSVFileFormatTokenizerTest.assertEquals((String)"the test", (String)tokens[1]);
    }

    public void testSimple11() {
        String line = "\"\"\"a, test, quote\"\" said\",the test";
        CSVFileFormatTokenizer tokeniser = new CSVFileFormatTokenizer(line);
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((String)"\"a, test, quote\" said", (String)tokeniser.next());
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((String)"the test", (String)tokeniser.next());
        CSVFileFormatTokenizerTest.assertTrue((!tokeniser.hasNext() ? 1 : 0) != 0);
    }

    public void testSimple12() throws ParseException {
        String line = "100,101.1,100000000000,4,4,100";
        CSVFileFormatTokenizer tokeniser = new CSVFileFormatTokenizer(line);
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((int)100, (int)tokeniser.nextInt());
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((Object)101.1, (Object)tokeniser.nextDouble());
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((long)100000000000L, (long)tokeniser.nextLong());
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((int)4, (int)tokeniser.nextByte());
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((int)4, (int)tokeniser.nextShort());
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        CSVFileFormatTokenizerTest.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(tokeniser.nextFloat()));
    }

    public void testSimple13() throws ParseException {
        String line = "100,12/30/06 4:58 PM";
        CSVFileFormatTokenizer tokeniser = new CSVFileFormatTokenizer(line);
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        Number number = tokeniser.nextNumber();
        CSVFileFormatTokenizerTest.assertEquals((int)100, (int)number.intValue());
        CSVFileFormatTokenizerTest.assertTrue((boolean)tokeniser.hasNext());
        Date date = tokeniser.nextDate();
        CSVFileFormatTokenizerTest.assertNotNull((Object)date);
    }
}

