/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.holiday.impl.financialcalendar;

import com.mbc.jfin.holiday.impl.financialcalendar.HolidayFileEntry;
import com.mbc.jfin.holiday.impl.financialcalendar.HolidaySource;
import com.mbc.jfin.holiday.impl.financialcalendar.InfoFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.TreeMap;
import org.joda.time.LocalDate;

public class HolidayFile
implements HolidaySource {
    private TreeMap<String, HolidayFileEntry> entries = new TreeMap();

    public HolidayFile(String holidayFileName, String infoFileName) throws IOException {
        this(new File(holidayFileName), new InfoFile(infoFileName));
    }

    public HolidayFile(String fileName, InfoFile infoFile) throws IOException {
        this(new File(fileName), infoFile);
    }

    public HolidayFile(File f, InfoFile infoFile) throws IOException {
        this(new FileReader(f), infoFile);
    }

    public HolidayFile(Reader reader, InfoFile infoFile) throws IOException {
        this.load(reader, infoFile);
    }

    public void load(Reader rawReader, InfoFile infoFile) throws IOException {
        BufferedReader reader = new BufferedReader(rawReader);
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            HolidayFileEntry holidayFileEntry = new HolidayFileEntry(line, infoFile);
            this.entries.put(holidayFileEntry.getReference(), holidayFileEntry);
        }
    }

    @Override
    public boolean isWeekend(LocalDate date, String locale) {
        HolidayFileEntry entry = this.entryFor(date, locale);
        if (entry == null) {
            return false;
        }
        return entry.getDescription().equals("Weekend");
    }

    @Override
    public boolean isHoliday(LocalDate date, String locale) {
        HolidayFileEntry entry = this.entryFor(date, locale);
        if (entry == null) {
            return false;
        }
        return !entry.getDescription().equals("Weekend");
    }

    private HolidayFileEntry entryFor(LocalDate date, String locale) {
        String reference = HolidayFileEntry.getReference(this.formatDate(date), locale);
        return this.entries.get(reference);
    }

    private String formatDate(LocalDate date) {
        return date.toString("yyyyMMdd");
    }
}

