/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.dedication.DecoderInputStream;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.dedication.QBlocks;

public class Professionnal {
    private static final Preferences prefs = Preferences.userNodeForPackage(Professionnal.class);
    private final String hostname;
    private final String organization;
    private final String mail;
    private final Date date1;
    private final Date date2;

    private Professionnal(String hostname, String organization, String mail, int date1, int date2) {
        this.hostname = hostname;
        this.organization = organization;
        this.mail = mail;
        this.date1 = new Date((long)date1 * 1000L);
        this.date2 = new Date((long)date2 * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Professionnal decodeNow(String license) throws IOException {
        QBlocks data = QBlocks.descodeAscii(license);
        QBlocks decrypted = data.change(Dedication.E, Dedication.N);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        decrypted.writeTo(baos, 512);
        baos.close();
        String hostname = OptionPrint.getHostName();
        try (InputStream source1 = null;){
            source1 = new DecoderInputStream(new ByteArrayInputStream(baos.toByteArray()), hostname);
            DataInputStream src = new DataInputStream(source1);
            byte version = src.readByte();
            if (version != 42) {
                throw new IOException();
            }
            String host1 = src.readUTF();
            String organization = src.readUTF();
            String mail = src.readUTF();
            int date1 = src.readInt();
            int date2 = src.readInt();
            Professionnal professionnal = new Professionnal(host1, organization, mail, date1, date2);
            return professionnal;
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getMail() {
        return this.mail;
    }

    public String getOrganization() {
        return this.organization;
    }

    public Date getDate1() {
        return this.date1;
    }

    public Date getDate2() {
        return this.date2;
    }
}

