/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.InstantArithmetic;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.ItemCaract;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericNumber;

class IncompleteItem
implements Item {
    private Map<ItemCaract, Numeric> data = new EnumMap<ItemCaract, Numeric>(ItemCaract.class);
    private final InstantArithmetic math;
    private final Item parent;
    private final String code;

    public IncompleteItem(String code, Item parent, InstantArithmetic math) {
        this.math = math;
        this.code = code;
        this.parent = parent;
    }

    public void setData(ItemCaract caract, Numeric value) {
        if (caract.getNumericType() != value.getNumericType()) {
            throw new IllegalArgumentException();
        }
        if (this.data.containsKey((Object)caract.getNumericType())) {
            throw new IllegalStateException();
        }
        this.data.put(caract, value);
        boolean change = false;
        do {
            change = false;
            change = this.eventuallyUseBeginComplete() || change;
            change = this.eventuallyUseBeginDuration() || change;
            change = this.eventuallyUseCompleteDuration() || change;
            change = this.eventuallyUseDurationWork() || change;
            change = this.eventuallyUseDurationLoad() || change;
        } while (change = this.eventuallyUseLoadWork() || change);
    }

    private boolean eventuallyUseDurationWork() {
        if (this.data.containsKey((Object)ItemCaract.DURATION) && this.data.containsKey((Object)ItemCaract.WORK) && !this.data.containsKey((Object)ItemCaract.LOAD)) {
            Duration d = (Duration)this.data.get((Object)ItemCaract.DURATION);
            NumericNumber w = (NumericNumber)this.data.get((Object)ItemCaract.WORK);
            this.data.put(ItemCaract.LOAD, new Load(d.getMinutes() * (long)w.getIntValue()));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseLoadWork() {
        if (this.data.containsKey((Object)ItemCaract.LOAD) && this.data.containsKey((Object)ItemCaract.WORK) && !this.data.containsKey((Object)ItemCaract.DURATION)) {
            Load l = (Load)this.data.get((Object)ItemCaract.LOAD);
            NumericNumber w = (NumericNumber)this.data.get((Object)ItemCaract.WORK);
            this.data.put(ItemCaract.DURATION, new Duration(l.getMinuteMen() / (long)w.getIntValue()));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseDurationLoad() {
        if (this.data.containsKey((Object)ItemCaract.DURATION) && this.data.containsKey((Object)ItemCaract.LOAD) && !this.data.containsKey((Object)ItemCaract.WORK)) {
            Duration d = (Duration)this.data.get((Object)ItemCaract.DURATION);
            Load l = (Load)this.data.get((Object)ItemCaract.LOAD);
            this.data.put(ItemCaract.WORK, new NumericNumber((int)(l.getMinuteMen() / d.getMinutes())));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseBeginDuration() {
        if (this.data.containsKey((Object)ItemCaract.BEGIN) && this.data.containsKey((Object)ItemCaract.DURATION) && !this.data.containsKey((Object)ItemCaract.COMPLETED)) {
            Instant i1 = (Instant)this.data.get((Object)ItemCaract.BEGIN);
            Duration d = (Duration)this.data.get((Object)ItemCaract.DURATION);
            this.data.put(ItemCaract.COMPLETED, this.math.add(i1, d));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseCompleteDuration() {
        if (this.data.containsKey((Object)ItemCaract.COMPLETED) && this.data.containsKey((Object)ItemCaract.DURATION) && !this.data.containsKey((Object)ItemCaract.BEGIN)) {
            Instant i2 = (Instant)this.data.get((Object)ItemCaract.COMPLETED);
            Duration d = (Duration)this.data.get((Object)ItemCaract.DURATION);
            this.data.put(ItemCaract.BEGIN, this.math.sub(i2, d));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseBeginComplete() {
        if (this.data.containsKey((Object)ItemCaract.BEGIN) && this.data.containsKey((Object)ItemCaract.COMPLETED) && !this.data.containsKey((Object)ItemCaract.DURATION)) {
            Instant i1 = (Instant)this.data.get((Object)ItemCaract.BEGIN);
            Instant i2 = (Instant)this.data.get((Object)ItemCaract.COMPLETED);
            if (i2.compareTo(i1) <= 0) {
                throw new IllegalArgumentException();
            }
            this.data.put(ItemCaract.DURATION, this.math.diff(i1, i2));
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.data.size() == EnumSet.allOf(ItemCaract.class).size();
    }

    @Override
    public Instant getBegin() {
        return (Instant)this.data.get((Object)ItemCaract.BEGIN);
    }

    @Override
    public Instant getCompleted() {
        return (Instant)this.data.get((Object)ItemCaract.COMPLETED);
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.data.get((Object)ItemCaract.DURATION);
    }

    @Override
    public Load getLoad() {
        return (Load)this.data.get((Object)ItemCaract.LOAD);
    }

    @Override
    public NumericNumber getWork() {
        return (NumericNumber)this.data.get((Object)ItemCaract.WORK);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Item getParent() {
        return this.parent;
    }

    @Override
    public List<Item> getChildren() {
        return null;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.code + " " + this.data.toString();
    }
}

