/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.brotli.BrotliInputStream;

public class Stdlib6 {
    private static final Map<String, Stdlib6> all = new ConcurrentHashMap<String, Stdlib6>();
    private static final String SEPARATOR = "\uf8ff";
    private final Map<String, List<String>> raw = new HashMap<String, List<String>>();
    private final String name;
    private final Map<String, String> info = new HashMap<String, String>();
    private final Pattern sizePattern = Pattern.compile("\\[(\\d+)x(\\d+)/16\\]");

    public static InputStream getResourceAsStream(String fullname) {
        int last = (fullname = fullname.toLowerCase().replace(".puml", "")).indexOf(47);
        if (last == -1) {
            return null;
        }
        try {
            Stdlib6 folder = Stdlib6.retrieve(fullname.substring(0, last));
            if (folder == null || folder.raw.size() == 0) {
                return null;
            }
            byte[] data = folder.getData(fullname.substring(last + 1));
            if (data == null) {
                return null;
            }
            return new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static InputStream getInternalInputStream(String fullname, String extension) {
        String res = "/stdlib/" + fullname + extension;
        return Stdlib6.class.getResourceAsStream(res);
    }

    private static Stdlib6 retrieve(String name) throws IOException {
        Stdlib6 result = all.get(name);
        if (result == null) {
            result = new Stdlib6(name);
            all.put(name, result);
        }
        return result;
    }

    private Stdlib6(String name) throws IOException {
        String filename;
        this.name = name;
        Log.info("Opening archive " + name);
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return;
        }
        this.fillMap(dataStream.readUTF());
        int pos = 0;
        while (!(filename = dataStream.readUTF()).equals(SEPARATOR)) {
            String s;
            ArrayList<String> text = new ArrayList<String>();
            while (!(s = dataStream.readUTF()).equals(SEPARATOR)) {
                text.add(s);
                if (!this.isSpriteLine(s)) continue;
                Matcher m = this.sizePattern.matcher(s);
                boolean ok = m.find();
                if (!ok) {
                    throw new IOException(s);
                }
                int width = Integer.parseInt(m.group(1));
                int height = Integer.parseInt(m.group(2));
                text.add("" + pos);
                pos += this.spriteSize(width, height);
                text.add("}");
            }
            this.raw.put(filename.toLowerCase(), text);
        }
        dataStream.close();
    }

    private int spriteSize(int width, int height) {
        int nbLines = (height + 1) / 2;
        return width * nbLines;
    }

    private String readSprite(int width, int height, InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        int nbLines = (height + 1) / 2;
        int line = 0;
        for (int j = 0; j < nbLines; ++j) {
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            for (int i = 0; i < width; ++i) {
                int b = inputStream.read();
                int b1 = (b & 0xF0) >> 4;
                int b2 = b & 0xF;
                sb1.append(this.toHexString(b1));
                sb2.append(this.toHexString(b2));
            }
            result.append(sb1.toString());
            result.append("\n");
            if (++line >= height) continue;
            result.append(sb2.toString());
            result.append("\n");
            ++line;
        }
        return result.toString();
    }

    private String toHexString(int b) {
        return Integer.toHexString(b).toUpperCase();
    }

    private boolean isSpriteLine(String s) {
        return s.trim().startsWith("sprite") && s.trim().endsWith("{");
    }

    private void fillMap(String infoString) {
        for (String s : infoString.split("\n")) {
            if (!s.contains("=")) continue;
            String[] data = s.split("=");
            this.info.put(data[0], data[1]);
        }
    }

    private DataInputStream getDataStream() throws IOException {
        InputStream raw = Stdlib6.getInternalInputStream(this.name, "-dat2.repx");
        if (raw == null) {
            return null;
        }
        return new DataInputStream(new BrotliInputStream(raw));
    }

    private InputStream getSpriteStream() throws IOException {
        InputStream raw = Stdlib6.getInternalInputStream(this.name, "-spr.repx");
        if (raw == null) {
            return null;
        }
        return new BrotliInputStream(raw);
    }

    private byte[] getData(String filename) throws IOException {
        List<String> result = this.raw.get(filename);
        if (result == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = result.iterator();
        while (it.hasNext()) {
            String s = it.next();
            sb.append(s);
            sb.append("\n");
            if (!this.isSpriteLine(s)) continue;
            Matcher m = this.sizePattern.matcher(s);
            boolean ok = m.find();
            if (!ok) {
                throw new IOException(s);
            }
            int width = Integer.parseInt(m.group(1));
            int height = Integer.parseInt(m.group(2));
            InputStream spriteStream = this.getSpriteStream();
            int pos = Integer.parseInt(it.next());
            spriteStream.skip(pos);
            sb.append(this.readSprite(width, height, spriteStream));
            sb.append("\n");
            spriteStream.close();
        }
        return sb.toString().getBytes("UTF-8");
    }

    public static void extractStdLib() throws IOException {
    }

    private static List<String> getAll() throws IOException {
        String name;
        ArrayList<String> result = new ArrayList<String>();
        InputStream home = Stdlib6.getInternalInputStream("home", ".repx");
        BufferedReader br = new BufferedReader(new InputStreamReader(home));
        while ((name = br.readLine()) != null) {
            result.add(name);
        }
        return Collections.unmodifiableList(result);
    }

    public static void addInfoVersion(List<String> strings) {
        try {
            for (String name : Stdlib6.getAll()) {
                Stdlib6 folder = new Stdlib6(name);
                strings.add("* " + name + " (Version " + folder.getVersion() + ")");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getVersion() {
        return this.info.get("VERSION");
    }
}

