/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import net.sourceforge.plantuml.geom.kinetic.SegmentCutter;
import net.sourceforge.plantuml.geom.kinetic.VectorForce;

public class Path {
    private final Frame frame1;
    private final Frame frame2;
    private final List<Point2DCharge> points1 = new ArrayList<Point2DCharge>();
    private final Map<Point2DCharge, Integer> points2 = new HashMap<Point2DCharge, Integer>();
    private static final double MINDIST = 30.0;

    public Path(Frame f1, Frame f2) {
        if (f1 == null || f2 == null) {
            throw new IllegalArgumentException();
        }
        this.frame1 = f1;
        this.frame2 = f2;
        this.updateCharges();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.frame1.getMainCorner());
        for (Point2DCharge p : this.points1) {
            sb.append(' ');
            sb.append(p);
        }
        sb.append(this.frame2.getMainCorner());
        return sb.toString();
    }

    private void updateCharges() {
        for (Point2DCharge pt : this.points1) {
            pt.setCharge(1.0);
        }
    }

    public void renderContinue() {
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
        Point2D cur = this.frame1.getMainCorner();
        for (Point2DCharge pc : this.points1) {
            SegmentCutter segmentCutter = new SegmentCutter(cur, pc, 30.0);
            newPoints.addAll(segmentCutter.intermediates());
            cur = pc;
        }
        SegmentCutter segmentCutter = new SegmentCutter(cur, this.frame2.getMainCorner(), 30.0);
        List<Point2D> in = segmentCutter.intermediates();
        newPoints.addAll(in.subList(0, in.size() - 1));
        this.points1.clear();
        this.points2.clear();
        for (Point2D pt : newPoints) {
            this.addIntermediate(new Point2DCharge(pt.getX(), pt.getY()));
        }
    }

    public List<Line2D> segments() {
        ArrayList<Line2D.Double> result = new ArrayList<Line2D.Double>();
        Point2D cur = this.frame1.getMainCorner();
        for (Point2D point2D : this.points1) {
            result.add(new Line2D.Double(cur, point2D));
            cur = point2D;
        }
        result.add(new Line2D.Double(cur, this.frame2.getMainCorner()));
        return Collections.unmodifiableList(result);
    }

    public void addIntermediate(Point2DCharge point2) {
        assert (this.points1.size() == this.points2.size());
        assert (!this.points1.contains(point2));
        assert (!this.points2.containsKey(point2));
        assert (!this.containsPoint2DCharge(point2));
        this.points1.add(point2);
        this.points2.put(point2, this.points2.size());
        assert (this.points1.size() == this.points2.size());
        assert (this.points1.contains(point2));
        assert (this.points2.containsKey(point2));
        assert (this.containsPoint2DCharge(point2));
        this.updateCharges();
    }

    public VectorForce getElasticForce(Point2DCharge point2) {
        int idx = this.points1.indexOf(point2);
        if (idx == -1) {
            throw new UnsupportedOperationException();
        }
        Point2D before = this.getPosition(idx - 1);
        Point2D after = this.getPosition(idx + 1);
        VectorForce f1 = new VectorForce(point2, before);
        VectorForce f2 = new VectorForce(point2, after);
        return f1.plus(f2).multiply(0.2);
    }

    private Point2D getPosition(int idx) {
        if (idx == -1) {
            return this.frame1.getMainCorner();
        }
        if (idx == this.points1.size()) {
            return this.frame2.getMainCorner();
        }
        return this.points1.get(idx);
    }

    public boolean containsPoint2DCharge(Point2DCharge p) {
        assert (this.points1.contains(p) == this.points2.containsKey(p)) : "p=" + p + "v1=" + this.points1.contains(p) + "v2=" + this.points2.containsKey(p) + " points1=" + this.points1 + " points2=" + this.points2;
        return this.points2.containsKey(p);
    }

    public final Collection<Point2DCharge> getPoints() {
        assert (this.points1.size() == this.points2.size());
        return Collections.unmodifiableCollection(this.points1);
    }
}

