/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "6-860AmER5DRWVz05mqtRsdC3wE5OekdFiA99Jtd00yCChUnCxOWUAuehg02v8LOSzl-wuP5HI5qgCA_ggpzBTFN3kjWmEMYEWvoSaK1Cfs8SH6qMc-nrEca90_odEvgROGc6Whp7KzqIYH-9gGNJuX8r4WIYxyaQ99kIF-42Y5hIz2iaM2fNV3h4EVWF3XDLej3CUmhKhpjIJUlLtOy56inEI8Fr1nyeswQcytLB1Lv4eXpb1IwVXvj7WTj_Y79naykn8P70Io06icBLc3iEAZWk0HOoA_9PcoKSUU93Iw2q8dxyKLPCBobAciwjd3SNe30wmz10EczYbhORFese4XBQz6qfAAEZoynbTaaJadrqd2Cjd6pH0pace3y1xtWtTkgBQzdl0mRITqX-HutXKQkzGRVuK2Vo094no00zSHC7y-FwjbIKgtsERxpR82xfLBDzaDFySe98SUVXr0M6mlW3T2XiR2Ml5iTDmlT8LwjRADUd3EJTnC1SLEcWONU9fjhqbUwoD5GENOJ5gQs3iURKO6Mk2ho1lX5Ay97dHEGihJut7GzRNmcjYRYmjwNa6zMirJu_zoBp7890MqDuqjqCM6rO0wi6fCi4O4rGFy6tDGaBvhhxLgEjzTDuUgcWNYhaecosWnW_rJSs7HDXRWwRknicGF0ojwAs3WUMqH8Q0Tq7bIUKMKHzjzTakMBnkYna7DyY8anY2RTNNaHStkefQjXH5sRfOFQAreJS846XKZBgMqL3HW8HC-cUZsCWNgb1vhkCyfv7ELRCTq2AyloMDLbeN16-CdFGrT-rDsYBX8ztVOFwOjwlv97bFxavDqIpMzAP4KlCsWVWIYrV1qYbd4RN1zCzjHY6iTb1ScniqKJFcD38ByKS4kFzRmUwRHcKrpLTNKJ2kE7-A85ge1D867dV4VR6OQZijusxqWQs-8rX7aNK3872PxIYTKOANIahoLaPDpiwRTEEtvPamLwZSgCFCXGk4AYY0C0";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 4, 5);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(new UTranslate(0.0, header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(new UTranslate(x, 0.0)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

