/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.sourceforge.plantuml.code.Compression;
import net.sourceforge.plantuml.code.CompressionZopfliZlib;

public class CompressionZlib
implements Compression {
    private static boolean USE_ZOPFLI = false;
    private static final int COMPRESSION_LEVEL = 9;

    @Override
    public byte[] compress(byte[] in) {
        if (USE_ZOPFLI) {
            return new CompressionZopfliZlib().compress(in);
        }
        if (in.length == 0) {
            return null;
        }
        int len = in.length * 2;
        if (len < 100) {
            len = 100;
        }
        byte[] result = null;
        while (result == null) {
            result = this.tryCompress(in, len);
            len *= 2;
        }
        return result;
    }

    private byte[] tryCompress(byte[] in, int len) {
        Deflater compresser = new Deflater(9, true);
        compresser.setInput(in);
        compresser.finish();
        byte[] output = new byte[len];
        int compressedDataLength = compresser.deflate(output);
        if (!compresser.finished()) {
            return null;
        }
        byte[] result = this.copyArray(output, compressedDataLength);
        return result;
    }

    @Override
    public byte[] decompress(byte[] in) throws IOException {
        byte[] in2 = new byte[in.length + 256];
        for (int i = 0; i < in.length; ++i) {
            in2[i] = in[i];
        }
        int len = in.length * 5;
        byte[] result = null;
        while (result == null) {
            result = this.tryDecompress(in2, len);
            len *= 2;
        }
        return result;
    }

    private byte[] tryDecompress(byte[] in, int len) throws IOException {
        byte[] tmp = new byte[len];
        Inflater decompresser = new Inflater(true);
        decompresser.setInput(in);
        try {
            int resultLength = decompresser.inflate(tmp);
            if (!decompresser.finished()) {
                return null;
            }
            decompresser.end();
            byte[] result = this.copyArray(tmp, resultLength);
            return result;
        }
        catch (DataFormatException e) {
            throw new IOException(e.toString());
        }
    }

    private byte[] copyArray(byte[] data, int len) {
        byte[] result = new byte[len];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[i];
        }
        return result;
    }
}

