/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.JavaClass;
import net.sourceforge.plantuml.classdiagram.command.JavaFile;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public class CommandImport
extends SingleLineCommand<ClassDiagram> {
    public CommandImport() {
        super("(?i)^import[%s]+[%g]?([^%g]+)[%g]?$");
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, List<String> arg) {
        String arg0 = arg.get(0);
        try {
            File f = FileSystem.getInstance().getFile(arg0);
            if (f.isFile()) {
                this.includeSimpleFile(classDiagram, f);
            } else if (f.isDirectory()) {
                this.includeDirectory(classDiagram, f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommandExecutionResult.error("IO error " + e);
        }
        return CommandExecutionResult.ok();
    }

    private void includeDirectory(ClassDiagram classDiagram, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            this.includeSimpleFile(classDiagram, f);
        }
    }

    private void includeSimpleFile(ClassDiagram classDiagram, File f) throws IOException {
        if (StringUtils.goLowerCase(f.getName()).endsWith(".java")) {
            this.includeFileJava(classDiagram, f);
        }
    }

    private void includeFileJava(ClassDiagram classDiagram, File f) throws IOException {
        JavaFile javaFile = new JavaFile(f);
        for (JavaClass cl : javaFile.getJavaClasses()) {
            Code name = Code.of(cl.getName());
            ILeaf ent1 = classDiagram.getOrCreateLeaf(name, cl.getType(), null);
            for (String p : cl.getParents()) {
                ILeaf ent2 = classDiagram.getOrCreateLeaf(Code.of(p), cl.getParentType(), null);
                Link link = new Link(ent2, ent1, new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS), Display.NULL, 2);
                classDiagram.addLink(link);
            }
        }
    }
}

