/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.FileFormat;

public class SuggestedFile {
    private final FileFormat fileFormat;
    private final int initialCpt;
    private final File outputFile;

    private SuggestedFile(File outputFile, FileFormat fileFormat, int initialCpt) {
        if (outputFile.getName().endsWith(fileFormat.getFileSuffix())) {
            throw new IllegalArgumentException();
        }
        this.outputFile = outputFile;
        this.fileFormat = fileFormat;
        this.initialCpt = initialCpt;
    }

    public String toString() {
        return this.outputFile.getAbsolutePath() + "[" + this.initialCpt + "]";
    }

    public static SuggestedFile fromOutputFile(File outputFile, FileFormat fileFormat) {
        return SuggestedFile.fromOutputFile(outputFile, fileFormat, 0);
    }

    public File getParentFile() {
        return this.outputFile.getParentFile();
    }

    public String getName() {
        return this.outputFile.getName();
    }

    public File getFile(int cpt) {
        String newName = this.fileFormat.changeName(this.outputFile.getName(), this.initialCpt + cpt);
        return new File(this.outputFile.getParentFile(), newName);
    }

    public static SuggestedFile fromOutputFile(File outputFile, FileFormat fileFormat, int initialCpt) {
        return new SuggestedFile(outputFile, fileFormat, initialCpt);
    }

    public File getTmpFile() {
        return new File(this.getParentFile(), this.getName() + ".tmp");
    }
}

