/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.LocationElements;
import com.mhuss.AstroLib.PlutoCoeffs;
import com.mhuss.AstroLib.PlutoTerms;

public class Pluto {
    public static void calcAllLEs(LocationElements loc, double t) {
        double arg;
        double mlJup = Math.toRadians(34.35 + 3034.9057 * t);
        double mlSat = Math.toRadians(50.08 + 1222.1138 * t);
        double mlPl = Math.toRadians(238.96 + 144.96 * t);
        double lon_ = 238.956785 + 144.96 * t;
        double lat_ = -3.908202;
        double rad_ = 407.247248;
        for (int i = 0; i < 7; ++i) {
            arg = i == 6 ? mlJup - mlPl : (double)(i + 1) * mlPl;
            double cosArg = Math.cos(arg) * 1.0E-6;
            double sinArg = Math.sin(arg) * 1.0E-6;
            long[] plc = PlutoTerms.plutoLongCoeff[i];
            lon_ += (double)plc[0] * sinArg + (double)plc[1] * cosArg;
            lat_ += (double)plc[2] * sinArg + (double)plc[3] * cosArg;
            rad_ += (double)plc[4] * sinArg + (double)plc[5] * cosArg;
        }
        PlutoCoeffs[] pc = PlutoTerms.plutoCoeff;
        for (int i = 0; i < 36; ++i) {
            if (0 == (pc[i].lon_a | pc[i].lon_b | pc[i].lat_a | pc[i].lat_b | pc[i].rad_a | pc[i].rad_b)) continue;
            if (0 == pc[i].j) {
                arg = 0.0;
            } else {
                double d = arg = 1 == pc[i].j ? mlJup : mlJup * (double)pc[i].j;
            }
            if (pc[i].s < 0) {
                arg -= -1 == pc[i].s ? mlSat : mlSat + mlSat;
            }
            if (pc[i].s > 0) {
                arg += 1 == pc[i].s ? mlSat : mlSat + mlSat;
            }
            if (0 != pc[i].p) {
                arg += mlPl * (double)pc[i].p;
            }
            double cosArg = Math.cos(arg) * 1.0E-6;
            double sinArg = Math.sin(arg) * 1.0E-6;
            lon_ += sinArg * (double)pc[i].lon_a + cosArg * (double)pc[i].lon_b;
            lat_ += sinArg * (double)pc[i].lat_a + cosArg * (double)pc[i].lat_b;
            rad_ += sinArg * (double)pc[i].rad_a + cosArg * (double)pc[i].rad_b;
        }
        loc.set(Math.toRadians(lat_), Math.toRadians(lon_), rad_ /= 10.0);
    }
}

