/*
 * Decompiled with CFR 0.152.
 */
package org.ea.javacnn.losslayers;

import org.ea.javacnn.data.DataBlock;
import org.ea.javacnn.data.OutputDefinition;
import org.ea.javacnn.losslayers.LossLayer;

public class SVMLayer
extends LossLayer {
    public SVMLayer(OutputDefinition def) {
        super(def);
    }

    @Override
    public DataBlock forward(DataBlock db, boolean training) {
        this.in_act = db;
        this.out_act = db;
        return db;
    }

    @Override
    public double backward(int y) {
        DataBlock x = this.in_act;
        x.clearGradient();
        double yscore = x.getWeight(y);
        double margin = 1.0;
        double loss = 0.0;
        for (int i = 0; i < this.out_depth; ++i) {
            double ydiff;
            if (y == i || !((ydiff = -yscore + x.getWeight(i) + margin) > 0.0)) continue;
            x.addGradient(i, 1.0);
            x.subGradient(y, 1.0);
            loss += ydiff;
        }
        return loss;
    }
}

