/*
 * Decompiled with CFR 0.152.
 */
package org.ea.javacnn.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ea.javacnn.data.BackPropResult;
import org.ea.javacnn.data.DataBlock;
import org.ea.javacnn.layers.Layer;

public class RectifiedLinearUnitsLayer
implements Layer,
Serializable {
    private DataBlock in_act;
    private DataBlock out_act;

    @Override
    public DataBlock forward(DataBlock db, boolean training) {
        this.in_act = db;
        DataBlock V2 = db.clone();
        int N = db.getWeights().length;
        double[] V2w = V2.getWeights();
        for (int i = 0; i < N; ++i) {
            if (!(V2w[i] < 0.0)) continue;
            V2.setGradient(i, 0.0);
        }
        this.out_act = V2;
        return this.out_act;
    }

    @Override
    public void backward() {
        DataBlock V = this.in_act;
        DataBlock V2 = this.out_act;
        int N = V.getWeights().length;
        V.clearGradient();
        for (int i = 0; i < N; ++i) {
            if (V2.getWeight(i) <= 0.0) {
                V.setGradient(i, 0.0);
                continue;
            }
            V.setGradient(i, V2.getGradient(i));
        }
    }

    @Override
    public List<BackPropResult> getBackPropagationResult() {
        return new ArrayList<BackPropResult>();
    }
}

