/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.structure;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.encog.engine.network.activation.ActivationBipolarSteepenedSigmoid;
import org.encog.engine.network.activation.ActivationClippedLinear;
import org.encog.engine.network.activation.ActivationGaussian;
import org.encog.engine.network.activation.ActivationSIN;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.visualize.structure.DrawnConnection;
import org.encog.workbench.tabs.visualize.structure.DrawnNeuron;
import org.encog.workbench.tabs.visualize.structure.DrawnNeuronType;
import org.encog.workbench.tabs.visualize.structure.LegendPanel;

public class GenomeStructureTab
extends EncogCommonTab {
    private VisualizationViewer<DrawnNeuron, DrawnConnection> vv;
    private NEATGenome genome;

    public GenomeStructureTab(NEATGenome genome) {
        super((ProjectFile)null);
        this.genome = genome;
        Graph<DrawnNeuron, DrawnConnection> g = null;
        g = this.buildGraph(genome);
        if (g == null) {
            throw new WorkBenchError("Can't visualize genome");
        }
        Function<DrawnNeuron, Point2D> staticTranformer = new Function<DrawnNeuron, Point2D>(){

            public Point2D apply(DrawnNeuron n) {
                int x = (int)(n.getX() * 600.0);
                int y = (int)(n.getY() * 300.0);
                Point result = new Point(x + 32, y);
                return result;
            }
        };
        Function<DrawnNeuron, Paint> vertexPaint = new Function<DrawnNeuron, Paint>(){

            public Paint apply(DrawnNeuron neuron) {
                switch (neuron.getType()) {
                    case Bias: {
                        return Color.yellow;
                    }
                    case Input: {
                        return Color.white;
                    }
                    case Output: {
                        return Color.green;
                    }
                    case Context: {
                        return Color.cyan;
                    }
                    case Linear: {
                        return Color.blue;
                    }
                    case Sigmoid: {
                        return Color.magenta;
                    }
                    case Gaussian: {
                        return Color.cyan;
                    }
                    case SIN: {
                        return Color.gray;
                    }
                }
                return Color.red;
            }
        };
        Function<DrawnConnection, Paint> edgePaint = new Function<DrawnConnection, Paint>(){

            public Paint apply(DrawnConnection connection) {
                if (connection.isContext()) {
                    return Color.lightGray;
                }
                return Color.black;
            }
        };
        StaticLayout layout = new StaticLayout(g);
        layout.setSize(new Dimension(5000, 5000));
        this.vv = new VisualizationViewer((Layout)layout);
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new ToStringLabeller());
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)GenomeStructureTab.this.vv, 1.1f, GenomeStructureTab.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)GenomeStructureTab.this.vv, 0.9090909f, GenomeStructureTab.this.vv.getCenter());
            }
        });
        JButton reset = new JButton("reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenomeStructureTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                GenomeStructureTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
            }
        });
        JPanel controls = new JPanel();
        controls.setLayout(new FlowLayout(0));
        controls.add(plus);
        controls.add(minus);
        controls.add(reset);
        Border border = BorderFactory.createEtchedBorder();
        controls.setBorder(border);
        this.add((Component)controls, "North");
        this.add((Component)new LegendPanel(true), "South");
    }

    private int calculateDepths(Map<Integer, DrawnNeuron> neuronMap) {
        ArrayList<DrawnNeuron> outputList = new ArrayList<DrawnNeuron>();
        int maxDepth = 0;
        int maxOutputDepth = 0;
        int pass = 0;
        while (pass < 1) {
            boolean done = false;
            while (!done) {
                done = true;
                for (NEATLinkGene neatLinkGene : this.genome.getLinksChromosome()) {
                    if (neatLinkGene.getFromNeuronID() == neatLinkGene.getToNeuronID()) continue;
                    DrawnNeuron fromNeuron = neuronMap.get((int)neatLinkGene.getFromNeuronID());
                    DrawnNeuron toNeuron = neuronMap.get((int)neatLinkGene.getToNeuronID());
                    if (fromNeuron.getDepth() == -1 || toNeuron.getDepth() == 0) continue;
                    if (toNeuron.getDepth() == -1) {
                        done = false;
                    }
                    int depth = fromNeuron.getDepth() + 1;
                    toNeuron.setDepth(Math.max(toNeuron.getDepth(), depth));
                    maxDepth = Math.max(depth, maxDepth);
                    if (toNeuron.getType() != DrawnNeuronType.Output) continue;
                    maxOutputDepth = Math.max(maxOutputDepth, depth);
                    outputList.add(toNeuron);
                }
            }
            ++pass;
        }
        ++maxDepth;
        for (DrawnNeuron neuron : outputList) {
            neuron.setDepth(maxDepth);
        }
        for (NEATLinkGene neatLinkGene : this.genome.getLinksChromosome()) {
            DrawnNeuron fromNeuron = neuronMap.get((int)neatLinkGene.getFromNeuronID());
            DrawnNeuron toNeuron = neuronMap.get((int)neatLinkGene.getToNeuronID());
            if (fromNeuron.getDepth() == -1) {
                fromNeuron.setDepth(0);
            }
            if (toNeuron.getDepth() != -1) continue;
            toNeuron.setDepth(0);
        }
        return maxDepth;
    }

    private void calculateXY(List<DrawnNeuron> neurons, int maxDepth) {
        int[] layerTotal = new int[maxDepth + 1];
        int[] layerCurrent = new int[maxDepth + 1];
        for (DrawnNeuron neuron : neurons) {
            if (neuron.getDepth() < 0) {
                neuron.setDepth(0);
            }
            int n = neuron.getDepth();
            layerTotal[n] = layerTotal[n] + 1;
        }
        for (DrawnNeuron neuron : neurons) {
            int n = neuron.getDepth();
            layerCurrent[n] = layerCurrent[n] + 1;
            neuron.setX((double)neuron.getDepth() * (1.0 / (double)layerTotal.length));
            neuron.setY((double)layerCurrent[neuron.getDepth()] * (1.0 / (double)layerTotal[neuron.getDepth()]));
        }
    }

    private Graph<DrawnNeuron, DrawnConnection> buildGraph(NEATGenome genome) {
        int inputCount = 1;
        int outputCount = 1;
        int hiddenCount = 1;
        int biasCount = 1;
        ArrayList<DrawnNeuron> neurons = new ArrayList<DrawnNeuron>();
        SparseMultigraph result = new SparseMultigraph();
        ArrayList connections = new ArrayList();
        HashMap<Integer, DrawnNeuron> neuronMap = new HashMap<Integer, DrawnNeuron>();
        for (NEATNeuronGene neuronGene : genome.getNeuronsChromosome()) {
            String name = "";
            int depth = -1;
            DrawnNeuronType t = DrawnNeuronType.Hidden;
            switch (neuronGene.getNeuronType()) {
                case Bias: {
                    depth = 0;
                    t = DrawnNeuronType.Bias;
                    name = "B" + biasCount++;
                    break;
                }
                case Input: {
                    depth = 0;
                    t = DrawnNeuronType.Input;
                    name = "I" + inputCount++;
                    break;
                }
                case Output: {
                    t = DrawnNeuronType.Output;
                    name = "O" + outputCount++;
                    break;
                }
                case Hidden: {
                    if (neuronGene.getActivationFunction() instanceof ActivationClippedLinear) {
                        t = DrawnNeuronType.Linear;
                    } else if (neuronGene.getActivationFunction() instanceof ActivationBipolarSteepenedSigmoid) {
                        t = DrawnNeuronType.Sigmoid;
                    } else if (neuronGene.getActivationFunction() instanceof ActivationGaussian) {
                        t = DrawnNeuronType.Gaussian;
                    } else if (neuronGene.getActivationFunction() instanceof ActivationSIN) {
                        t = DrawnNeuronType.SIN;
                    }
                    name = "H" + hiddenCount++;
                }
            }
            DrawnNeuron neuron = new DrawnNeuron(t, name);
            neurons.add(neuron);
            neuron.setDepth(depth);
            neuronMap.put((int)neuronGene.getId(), neuron);
        }
        for (NEATLinkGene neatLinkGene : genome.getLinksChromosome()) {
            if (!neatLinkGene.isEnabled()) continue;
            DrawnNeuron fromNeuron = (DrawnNeuron)neuronMap.get((int)neatLinkGene.getFromNeuronID());
            DrawnNeuron toNeuron = (DrawnNeuron)neuronMap.get((int)neatLinkGene.getToNeuronID());
            DrawnConnection connection = new DrawnConnection(fromNeuron, toNeuron, neatLinkGene.getWeight());
            fromNeuron.getOutbound().add(connection);
            toNeuron.getInbound().add(connection);
        }
        int maxDepth = this.calculateDepths(neuronMap);
        this.calculateXY(neurons, maxDepth);
        for (DrawnNeuron neuron : neurons) {
            result.addVertex((Object)neuron);
            for (DrawnConnection connection : neuron.getOutbound()) {
                result.addEdge((Object)connection, (Object)connection.getFrom(), (Object)connection.getTo(), EdgeType.DIRECTED);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return "NEAT Genome";
    }
}

