/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.structure;

import java.util.ArrayList;
import java.util.List;
import org.encog.workbench.tabs.visualize.structure.DrawnConnection;
import org.encog.workbench.tabs.visualize.structure.DrawnNeuronType;

public class DrawnNeuron {
    private final DrawnNeuronType type;
    private final List<DrawnConnection> outbound = new ArrayList<DrawnConnection>();
    private final List<DrawnConnection> inbound = new ArrayList<DrawnConnection>();
    private String name;
    private int depth = -1;
    private double x;
    private double y;

    public DrawnNeuron(DrawnNeuronType type, String name) {
        this.type = type;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public DrawnNeuronType getType() {
        return this.type;
    }

    public List<DrawnConnection> getOutbound() {
        return this.outbound;
    }

    public List<DrawnConnection> getInbound() {
        return this.outbound;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String getToolTip() {
        StringBuilder result = new StringBuilder();
        switch (this.type) {
            case Input: {
                result.append("Input");
                break;
            }
            case Hidden: {
                result.append("Hidden");
                break;
            }
            case Context: {
                result.append("Context");
                break;
            }
            case Bias: {
                result.append("Bias");
                break;
            }
            case Output: {
                result.append("Output");
            }
        }
        result.append(" : ");
        result.append(this.name);
        return result.toString();
    }

    public Object getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }
}

