/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.epl;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedOrderedSparseMultigraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;

public class EPLTreeTab
extends EncogCommonTab {
    private VisualizationViewer<ProgramNode, Integer> vv;
    private Forest<ProgramNode, Integer> graph = new DelegateForest((DirectedGraph)new DirectedOrderedSparseMultigraph());
    private int edgeIndex = 0;

    public EPLTreeTab(EncogProgram prg) {
        super((ProjectFile)null);
        this.buildGraph(prg);
        TreeLayout treeLayout = new TreeLayout(this.graph);
        Function<ProgramNode, Paint> vertexPaint = new Function<ProgramNode, Paint>(){

            public Paint apply(ProgramNode v) {
                return Color.white;
            }
        };
        this.vv = new VisualizationViewer((Layout)treeLayout, new Dimension(600, 600));
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.setVertexToolTipTransformer((Function)new ToStringLabeller());
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)EPLTreeTab.this.vv, 1.1f, EPLTreeTab.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)EPLTreeTab.this.vv, 0.9090909f, EPLTreeTab.this.vv.getCenter());
            }
        });
        JButton reset = new JButton("reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EPLTreeTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                EPLTreeTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
            }
        });
        JPanel controls = new JPanel();
        controls.setLayout(new FlowLayout(0));
        controls.add(plus);
        controls.add(minus);
        controls.add(reset);
        Border border = BorderFactory.createEtchedBorder();
        controls.setBorder(border);
        this.add((Component)controls, "North");
    }

    private void buildGraph(EncogProgram prg) {
        ProgramNode root = prg.getRootNode();
        this.graph.addVertex((Object)root);
        this.graphNode(root);
    }

    private void graphNode(ProgramNode parentNode) {
        int i = 0;
        while (i < parentNode.getChildNodes().size()) {
            ProgramNode childNode = parentNode.getChildNode(i);
            this.graphNode(childNode);
            this.graph.addEdge((Object)new Integer(this.edgeIndex++), (Object)parentNode, (Object)childNode);
            ++i;
        }
    }

    @Override
    public String getName() {
        return "Structure: " + this.getEncogObject().getName();
    }
}

