/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.query.ocr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class DrawingEntry
extends JPanel {
    private static final long serialVersionUID = 656936515012546346L;
    protected Image entryImage;
    protected Graphics entryGraphics;
    protected int lastX = -1;
    protected int lastY = -1;
    protected int downSampleLeft;
    protected int downSampleRight;
    protected int downSampleTop;
    protected int downSampleBottom;
    protected double ratioX;
    protected double ratioY;
    protected int[] pixelMap;

    public DrawingEntry() {
        this.enableEvents(49L);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public void clear() {
        this.entryGraphics.setColor(Color.white);
        this.entryGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.downSampleRight = 0;
        this.downSampleLeft = 0;
        this.downSampleTop = 0;
        this.downSampleBottom = 0;
        this.repaint();
    }

    public boolean[] downSample(int targetWidth, int targetHeight) {
        int w = this.entryImage.getWidth(this);
        int h = this.entryImage.getHeight(this);
        boolean[] result = new boolean[targetWidth * targetHeight];
        PixelGrabber grabber = new PixelGrabber(this.entryImage, 0, 0, w, h, true);
        try {
            grabber.grabPixels();
            this.pixelMap = (int[])grabber.getPixels();
            this.findBounds(w, h);
            this.ratioX = (double)(this.downSampleRight - this.downSampleLeft) / (double)targetWidth;
            this.ratioY = (double)(this.downSampleBottom - this.downSampleTop) / (double)targetHeight;
            int index = 0;
            int y = 0;
            while (y < targetHeight) {
                int x = 0;
                while (x < targetWidth) {
                    result[index++] = this.downSampleRegion(x, y);
                    ++x;
                }
                ++y;
            }
            this.repaint();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    protected boolean downSampleRegion(int x, int y) {
        int w = this.entryImage.getWidth(this);
        int startX = (int)((double)this.downSampleLeft + (double)x * this.ratioX);
        int startY = (int)((double)this.downSampleTop + (double)y * this.ratioY);
        int endX = (int)((double)startX + this.ratioX);
        int endY = (int)((double)startY + this.ratioY);
        int yy = startY;
        while (yy <= endY) {
            int xx = startX;
            while (xx <= endX) {
                int loc = xx + yy * w;
                if (this.pixelMap[loc] != -1) {
                    return true;
                }
                ++xx;
            }
            ++yy;
        }
        return false;
    }

    protected void findBounds(int w, int h) {
        int y = 0;
        while (y < h) {
            if (!this.hLineClear(y)) {
                this.downSampleTop = y;
                break;
            }
            ++y;
        }
        y = h - 1;
        while (y >= 0) {
            if (!this.hLineClear(y)) {
                this.downSampleBottom = y;
                break;
            }
            --y;
        }
        int x = 0;
        while (x < w) {
            if (!this.vLineClear(x)) {
                this.downSampleLeft = x;
                break;
            }
            ++x;
        }
        x = w - 1;
        while (x >= 0) {
            if (!this.vLineClear(x)) {
                this.downSampleRight = x;
                break;
            }
            --x;
        }
    }

    protected boolean hLineClear(int y) {
        int w = this.entryImage.getWidth(this);
        int i = 0;
        while (i < w) {
            if (this.pixelMap[y * w + i] != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void initImage() {
        this.entryImage = this.createImage(this.getWidth(), this.getHeight());
        this.entryGraphics = this.entryImage.getGraphics();
        this.entryGraphics.setColor(Color.white);
        this.entryGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        if (this.entryImage == null) {
            this.initImage();
        }
        g.drawImage(this.entryImage, 0, 0, this);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.red);
        g.drawRect(this.downSampleLeft, this.downSampleTop, this.downSampleRight - this.downSampleLeft, this.downSampleBottom - this.downSampleTop);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() != 501) {
            return;
        }
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() != 506) {
            return;
        }
        this.entryGraphics.setColor(Color.black);
        this.entryGraphics.drawLine(this.lastX, this.lastY, e.getX(), e.getY());
        this.getGraphics().drawImage(this.entryImage, 0, 0, this);
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    protected boolean vLineClear(int x) {
        int w = this.entryImage.getWidth(this);
        int h = this.entryImage.getHeight(this);
        int i = 0;
        while (i < h) {
            if (this.pixelMap[i * w + x] != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

