/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.population.neat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.species.Species;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.population.neat.EditNEATPopulationDialog;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.models.population.neat.GeneralPopulationModel;
import org.encog.workbench.models.population.neat.InnovationModel;
import org.encog.workbench.models.population.neat.SpeciesModel;
import org.encog.workbench.process.TrainBasicNetwork;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.population.neat.NEATPopulationInfo;
import org.encog.workbench.tabs.visualize.structure.GenomeStructureTab;

public class NEATPopulationTab
extends EncogCommonTab
implements ActionListener,
MouseListener {
    private JButton btnTrain;
    private JButton btnEdit;
    private JButton btnReset;
    private JTabbedPane tabViews;
    private final JScrollPane populationScroll;
    private final JTable populationTable;
    private final GeneralPopulationModel populationModel;
    private final JScrollPane speciesScroll;
    private final JTable speciesTable;
    private final SpeciesModel speciesModel;
    private final JScrollPane innovationScroll;
    private final JTable innovationTable;
    private final InnovationModel innovationModel;
    private JTable tableGeneralPopulation;
    private NEATPopulation population;
    private final NEATPopulationInfo pi;
    private List<Genome> list;

    public NEATPopulationTab(ProjectEGFile obj) {
        super(obj);
        this.setDirty(true);
        this.population = (NEATPopulation)obj.getObject();
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "North");
        this.btnTrain = new JButton("Train");
        buttonPanel.add(this.btnTrain);
        this.btnEdit = new JButton("Edit Population");
        buttonPanel.add(this.btnEdit);
        this.btnReset = new JButton("Reset");
        buttonPanel.add(this.btnReset);
        this.btnTrain.addActionListener(this);
        this.btnEdit.addActionListener(this);
        this.btnReset.addActionListener(this);
        JPanel mainPanel = new JPanel();
        this.add((Component)mainPanel, "Center");
        mainPanel.setLayout(new BorderLayout());
        JPanel about = new JPanel();
        about.setLayout(new BorderLayout());
        this.pi = new NEATPopulationInfo(this.population);
        about.add((Component)this.pi, "Center");
        mainPanel.add((Component)about, "North");
        this.tabViews = new JTabbedPane();
        mainPanel.add((Component)this.tabViews, "Center");
        this.populationModel = new GeneralPopulationModel(this.population);
        this.populationTable = new JTable(this.populationModel);
        this.populationTable.addMouseListener(this);
        this.populationScroll = new JScrollPane(this.populationTable);
        this.speciesModel = new SpeciesModel(this.population);
        this.speciesTable = new JTable(this.speciesModel);
        this.speciesScroll = new JScrollPane(this.speciesTable);
        this.speciesTable.addMouseListener(this);
        this.innovationModel = new InnovationModel(this.population);
        this.innovationTable = new JTable(this.innovationModel);
        this.innovationScroll = new JScrollPane(this.innovationTable);
        this.tabViews.addTab("General Population", this.populationScroll);
        this.tabViews.addTab("Species", this.speciesScroll);
        this.tabViews.addTab("Innovation", this.innovationScroll);
        this.list = this.population.flatten();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.btnTrain) {
                this.performTrain();
            } else if (e.getSource() == this.btnEdit) {
                this.performEdit();
            } else if (e.getSource() == this.btnReset) {
                this.performReset();
            }
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    private void performEdit() {
        EditNEATPopulationDialog dialog = new EditNEATPopulationDialog();
        dialog.getPopulationSize().setValue(this.population.getPopulationSize());
        dialog.getSurvivalRate().setValue(this.population.getSurvivalRate());
        if (!this.population.isHyperNEAT()) {
            ActivationFunction activationFunction = this.population.getActivationFunctions().getList().get(0).getObj();
        }
        dialog.getActivationCycles().setValue(this.population.getActivationCycles());
        if (dialog.process()) {
            this.population.setPopulationSize(dialog.getPopulationSize().getValue());
            this.population.setSurvivalRate(dialog.getSurvivalRate().getValue());
            if (!this.population.isHyperNEAT()) {
                this.population.setNEATActivationFunction(dialog.getNeatActivationFunction());
            }
            this.population.setActivationCycles(dialog.getActivationCycles().getValue());
            this.pi.repaint();
        }
    }

    private void performTrain() {
        TrainBasicNetwork t = new TrainBasicNetwork((ProjectEGFile)this.getEncogObject(), this);
        t.performTrain();
    }

    @Override
    public String getName() {
        return "Population: " + this.getEncogObject().getName();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            Species species;
            NEATGenome genome;
            JTable target = (JTable)e.getSource();
            int row = target.getSelectedRow();
            if (target == this.populationTable) {
                NEATGenome genome2 = (NEATGenome)this.list.get(row);
                GenomeStructureTab tab = new GenomeStructureTab(genome2);
                EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
            } else if (target == this.speciesTable && (genome = (NEATGenome)(species = this.population.getSpecies().get(row)).getLeader()) != null) {
                GenomeStructureTab tab = new GenomeStructureTab(genome);
                EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
            }
        }
    }

    public void performReset() {
        EncogWorkBench.getInstance();
        String str = EncogWorkBench.displayInput("New population size");
        try {
            int sz = Integer.parseInt(str);
            if (sz < 10) {
                EncogWorkBench.displayError("Error", "Population size must be at least 10.");
                return;
            }
            this.population.reset();
            this.repaint();
            this.pi.repaint();
        }
        catch (NumberFormatException ex) {
            EncogWorkBench.displayError("Error", "Invalid population size.");
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

