/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.population.neat;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.encog.neural.neat.NEATPopulation;
import org.encog.util.Format;
import org.encog.workbench.WorkbenchFonts;

public class NEATPopulationInfo
extends JPanel {
    NEATPopulation population;

    public NEATPopulationInfo(NEATPopulation population) {
        this.population = population;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setFont(WorkbenchFonts.getTitle2Font());
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getHeight();
        g.drawString("Maximum Population Count:", 20, y);
        g.drawString("NEAT Act. Function:", 580, y);
        g.drawString("Current Population Count:", 20, y += fm.getHeight());
        g.drawString("Input Count:", 580, y);
        g.drawString("Species Count:", 20, y += fm.getHeight());
        g.drawString("Output Count:", 580, y);
        g.drawString("Innovation Count:", 20, y += fm.getHeight());
        g.drawString("Cycles:", 580, y);
        g.drawString("Population Type:", 20, y += fm.getHeight());
        g.drawString("Survival Rate:", 300, y);
        g.drawString("Best Genome Score:", 20, y += fm.getHeight());
        int populationSize = 0;
        int speciesSize = 0;
        int innovationsSize = 0;
        double bestScore = 0.0;
        populationSize = this.population.flatten().size();
        if (this.population.getSpecies() != null) {
            speciesSize = this.population.getSpecies().size();
        }
        if (this.population.getInnovations() != null) {
            innovationsSize = this.population.getInnovations().getInnovations().size();
        }
        String type = "Neat";
        y = fm.getHeight();
        g.setFont(WorkbenchFonts.getTextFont());
        g.drawString(Format.formatInteger(this.population.getPopulationSize()), 200, y);
        String af = this.population.isHyperNEAT() ? "HyperNEAT" : this.population.getActivationFunctions().getList().get(0).getObj().getClass().getSimpleName();
        g.drawString(af, 730, y);
        g.drawString(Format.formatInteger(populationSize), 200, y += fm.getHeight());
        g.drawString(Format.formatInteger(this.population.getInputCount()), 730, y);
        g.drawString(Format.formatInteger(speciesSize), 200, y += fm.getHeight());
        g.drawString(Format.formatInteger(this.population.getOutputCount()), 730, y);
        g.drawString(Format.formatInteger(innovationsSize), 200, y += fm.getHeight());
        g.drawString(Format.formatInteger(this.population.getActivationCycles()), 730, y);
        g.drawString(type, 200, y += fm.getHeight());
        g.drawString(Format.formatPercent(this.population.getSurvivalRate()), 450, y);
        g.drawString(Format.formatDouble(bestScore, 2), 200, y += fm.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(620, 100);
    }
}

