/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.EncogCommonFrame;
import org.encog.workbench.frames.document.EncogDocumentFrame;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.ButtonTabComponent;
import org.encog.workbench.tabs.EncogCommonTab;

public class EncogTabManager {
    private final List<EncogCommonTab> tabs = new ArrayList<EncogCommonTab>();
    private final EncogDocumentFrame owner;
    private final JTabbedPane documentTabs;
    private boolean modalTabOpen;

    public EncogTabManager(EncogDocumentFrame owner) {
        this.owner = owner;
        this.documentTabs = new JTabbedPane();
        this.documentTabs.setTabLayoutPolicy(0);
    }

    public void add(EncogCommonTab tab) {
        this.tabs.add(tab);
        tab.setParent(this.owner);
    }

    public boolean contains(EncogCommonTab tab) {
        return this.tabs.contains(tab);
    }

    public List<EncogCommonTab> getTabs() {
        return this.tabs;
    }

    public EncogCommonFrame getOwner() {
        return this.owner;
    }

    public void remove(EncogCommonTab frame) {
        this.tabs.remove(frame);
    }

    public boolean isTrainingOrNetworkOpen() {
        return false;
    }

    public boolean alreadyOpen(EncogCommonTab tab) {
        return this.tabs.contains(tab);
    }

    public EncogCommonTab find(File file) {
        for (EncogCommonTab tab : this.tabs) {
            ProjectFile pf = tab.getEncogObject();
            if (pf == null || !file.equals(pf.getFile())) continue;
            return tab;
        }
        return null;
    }

    public void closeAll() {
        Object[] list = this.tabs.toArray();
        int i = 0;
        while (i < list.length) {
            EncogCommonTab tab = (EncogCommonTab)list[i];
            tab.dispose();
            ++i;
        }
    }

    public void closeAll(File f) {
        Object[] list = this.tabs.toArray();
        int i = 0;
        while (i < list.length) {
            EncogCommonTab tab = (EncogCommonTab)list[i];
            if (tab.getEncogObject() != null && tab.getEncogObject().getFile() != null && tab.getEncogObject().getFile().equals(f)) {
                tab.dispose();
            }
            ++i;
        }
    }

    public boolean queryViews(File f) {
        if (!this.checkViews(f)) {
            return true;
        }
        if (!EncogWorkBench.askQuestion("Views Open", "There are view(s) open to the file:\n" + f.toString() + "\nClose any views first?")) {
            return false;
        }
        this.closeAll(f);
        return true;
    }

    public boolean checkViews(File f) {
        Object[] list = this.tabs.toArray();
        int i = 0;
        while (i < list.length) {
            EncogCommonTab tab = (EncogCommonTab)list[i];
            if (tab.getEncogObject() != null && tab.getEncogObject().getFile() != null && tab.getEncogObject().getFile().equals(f)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public JTabbedPane getDocumentTabs() {
        return this.documentTabs;
    }

    public EncogCommonTab getCurrentTab() {
        EncogCommonTab currentTab = (EncogCommonTab)this.documentTabs.getSelectedComponent();
        return currentTab;
    }

    public void openTab(EncogCommonTab tab) {
        int i = this.documentTabs.getTabCount();
        this.documentTabs.add(tab.getName(), tab);
        if (!this.contains(tab)) {
            if (i < this.documentTabs.getTabCount()) {
                this.documentTabs.setTabComponentAt(i, new ButtonTabComponent(this, tab));
            }
            this.add(tab);
        }
        this.selectTab(tab);
        EncogWorkBench.getInstance().getMainWindow().getMenus().updateMenus();
    }

    public void selectTab(EncogCommonTab tab) {
        this.documentTabs.setSelectedComponent(tab);
    }

    public void openModalTab(EncogCommonTab tab, String title) {
        if (this.alreadyOpen(tab)) {
            return;
        }
        int i = this.documentTabs.getTabCount();
        this.documentTabs.add(title, tab);
        this.documentTabs.setTabComponentAt(i, new ButtonTabComponent(this, tab));
        this.add(tab);
        tab.setModal(true);
        this.documentTabs.setSelectedComponent(tab);
        this.documentTabs.setEnabled(false);
        EncogWorkBench.getInstance().getMainWindow().getTree().setEnabled(false);
        this.modalTabOpen = true;
        EncogWorkBench.getInstance().getMainWindow().getMenus().updateMenus();
    }

    public void closeTab(EncogCommonTab tab) throws IOException {
        if (tab.close()) {
            this.remove(tab);
            this.getDocumentTabs().remove(tab);
            if (tab.isModal()) {
                this.documentTabs.setEnabled(true);
                EncogWorkBench.getInstance().getMainWindow().getTree().setEnabled(true);
                this.modalTabOpen = false;
            }
            EncogWorkBench.getInstance().getMainWindow().getMenus().updateMenus();
        }
    }

    public boolean isModalTabOpen() {
        return this.modalTabOpen;
    }

    public boolean notWithModalTabOpen() {
        if (this.modalTabOpen) {
            EncogWorkBench.displayError("Error", "Please close modal tab first.");
        }
        return this.modalTabOpen;
    }

    public void renameTab(EncogCommonTab tab, String name) {
        int index = this.documentTabs.indexOfComponent(tab);
        if (index != -1) {
            this.documentTabs.setTitleAt(index, name);
        }
    }
}

