/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.models.population.neat;

import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.encog.ml.ea.genome.Genome;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.util.Format;

public class GeneralPopulationModel
implements TableModel {
    private NEATPopulation population;
    private int maxGeneration;
    private List<Genome> list;
    public static String[] COLUMNS = new String[]{"Neurons", "Links", "Score", "Age", "Birth Generation"};

    public GeneralPopulationModel(NEATPopulation population) {
        this.population = population;
        this.maxGeneration = 0;
        this.list = this.population.flatten();
        for (Genome g : this.list) {
            NEATGenome genome = (NEATGenome)g;
            this.maxGeneration = Math.max(this.maxGeneration, genome.getBirthGeneration());
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        NEATGenome genome = (NEATGenome)this.list.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return Format.formatInteger(genome.getNeuronsChromosome().size());
            }
            case 1: {
                return Format.formatInteger(genome.getLinksChromosome().size());
            }
            case 2: {
                return Format.formatDouble(genome.getScore(), 4);
            }
            case 3: {
                return Format.formatInteger(this.maxGeneration - genome.getBirthGeneration());
            }
            case 4: {
                return Format.formatInteger(genome.getBirthGeneration());
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

