/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MapDataModel
implements TableModel {
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private Map<String, String> data;
    private String[] properties;

    public MapDataModel(Map<String, String> data) {
        this.data = data;
        this.updateProperties();
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int c) {
        if (c == 1) {
            return "Value";
        }
        return "Name";
    }

    @Override
    public int getRowCount() {
        return this.properties.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String key = this.properties[row];
        if (col == 0) {
            return key;
        }
        return this.data.get(key);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        String key = this.properties[row];
        String value = (String)obj;
        if (col == 1) {
            this.data.put(key, value);
        }
    }

    public void updateProperties() {
        this.properties = new String[this.data.size()];
        int i = 0;
        for (String key : this.data.keySet()) {
            this.properties[i++] = key;
        }
        this.updateListeners();
    }

    public void updateListeners() {
        TableModelEvent event = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public void addProperty(String input) {
        this.data.put(input, "");
        this.updateProperties();
    }

    public void deleteRow(int row) {
        String key = this.properties[row];
        this.data.remove(key);
        this.updateProperties();
    }
}

