/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames.document.tree;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.encog.util.file.FileUtil;
import org.encog.workbench.frames.document.tree.ProjectDirectory;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.frames.document.tree.ProjectParent;

public class ProjectTreeRenderer
extends DefaultTreeCellRenderer {
    private Icon iconFolder = ProjectTreeRenderer.getImageIcon("org/encog/workbench/data/icons/tree/tree-folder.png");
    private Icon iconFileCSV = ProjectTreeRenderer.getImageIcon("org/encog/workbench/data/icons/tree/tree-leaf-csv.png");
    private Icon iconFileEG = ProjectTreeRenderer.getImageIcon("org/encog/workbench/data/icons/tree/tree-leaf-ml.png");
    private Icon iconFileEGB = ProjectTreeRenderer.getImageIcon("org/encog/workbench/data/icons/tree/tree-leaf-egb.png");
    private Icon iconFileEGA = ProjectTreeRenderer.getImageIcon("org/encog/workbench/data/icons/tree/tree-leaf-ega.png");
    private Icon iconFileTxt = ProjectTreeRenderer.getImageIcon("org/encog/workbench/data/icons/tree/tree-leaf-txt.png");
    private Icon iconFileUnknown = ProjectTreeRenderer.getImageIcon("org/encog/workbench/data/icons/tree/tree-leaf.png");

    public static ImageIcon getImageIcon(String name) {
        return new ImageIcon(ClassLoader.getSystemResource(name));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof ProjectEGFile) {
            ((JLabel)result).setIcon(this.iconFileEG);
        } else if (value instanceof ProjectParent || value instanceof ProjectDirectory) {
            ((JLabel)result).setIcon(this.iconFolder);
        } else if (value instanceof ProjectFile) {
            String ext = FileUtil.getFileExt(((ProjectFile)value).getFile());
            if (ext.equalsIgnoreCase("txt") || ext.equalsIgnoreCase("html")) {
                ((JLabel)result).setIcon(this.iconFileTxt);
            } else if (ext.equalsIgnoreCase("csv")) {
                ((JLabel)result).setIcon(this.iconFileCSV);
            } else if (ext.equalsIgnoreCase("EGB")) {
                ((JLabel)result).setIcon(this.iconFileEGB);
            } else if (ext.equalsIgnoreCase("EGA")) {
                ((JLabel)result).setIcon(this.iconFileEGA);
            } else {
                ((JLabel)result).setIcon(this.iconFileUnknown);
            }
        } else {
            ((JLabel)result).setIcon(this.iconFileUnknown);
        }
        return result;
    }
}

