/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.EncogCommonFrame;
import org.encog.workbench.models.MapDataModel;

public class MapDataFrame
extends EncogCommonFrame {
    private JPanel panelButtons;
    private JScrollPane scroll;
    private JTable table;
    private JButton btnAdd;
    private MapDataModel model;
    private JButton btnDel;
    private Map<String, String> data;

    public MapDataFrame(Map<String, String> data, String title) {
        this.setEncogObject(data);
        this.setSize(400, 400);
        this.setTitle(title);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.panelButtons = new JPanel();
        this.panelButtons.setLayout(new FlowLayout(0));
        content.add((Component)this.panelButtons, "North");
        this.model = new MapDataModel(data);
        this.table = new JTable(this.model);
        this.scroll = new JScrollPane(this.table);
        content.add((Component)this.scroll, "Center");
        this.btnAdd = new JButton("Add Row");
        this.btnDel = new JButton("Delete Row");
        this.panelButtons.add(this.btnAdd);
        this.btnAdd.addActionListener(this);
        this.panelButtons.add(this.btnDel);
        this.btnDel.addActionListener(this);
        this.data = data;
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public boolean validate(String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                EncogWorkBench.displayError("Error", "Name contains an invalid character.");
                return false;
            }
            ++i;
        }
        if (this.data.containsKey(str)) {
            EncogWorkBench.displayError("Error", "Name already defined.");
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnAdd) {
            String input = EncogWorkBench.displayInput("Enter the property to add? (no spaces)");
            if (input != null && this.validate(input)) {
                this.model.addProperty(input);
            }
        } else if (e.getSource() == this.btnDel) {
            int row = this.table.getSelectedRow();
            if (row == -1) {
                EncogWorkBench.displayError("Error", "Please select the row that you wish to delete.");
                return;
            }
            if (EncogWorkBench.askQuestion("Are you sure", "Are you sure you want to delete this property row?")) {
                this.model.deleteRow(row);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }
}

