/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.editor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.editor.PropertyCollection;

public class ObjectEditorModel
implements TableModel {
    private PropertyCollection data;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    public ObjectEditorModel(PropertyCollection data) {
        this.data = data;
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Name";
        }
        return "Value";
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.data == null) {
            return null;
        }
        if (col == 0) {
            return this.data.getFieldName(row);
        }
        try {
            Object value = this.data.getField(row).get(this.data.getData());
            return value;
        }
        catch (IllegalArgumentException e) {
            throw new WorkBenchError(e);
        }
        catch (IllegalAccessException e) {
            throw new WorkBenchError(e);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            try {
                Field field = this.data.getField(row);
                Class<?> type = field.getType();
                if (type == Byte.TYPE) {
                    field.setByte(this.data.getData(), Byte.parseByte((String)value));
                } else if (type == Short.TYPE) {
                    field.setShort(this.data.getData(), Short.parseShort((String)value));
                } else if (type == Integer.TYPE) {
                    field.setInt(this.data.getData(), Integer.parseInt((String)value));
                } else if (type == Long.TYPE) {
                    field.setLong(this.data.getData(), Long.parseLong((String)value));
                } else if (type == String.class) {
                    field.set(this.data.getData(), value);
                } else if (type == Double.TYPE) {
                    field.setDouble(this.data.getData(), Double.parseDouble((String)value));
                } else if (type == Float.TYPE) {
                    field.setFloat(this.data.getData(), Float.parseFloat((String)value));
                } else if (type == Boolean.TYPE) {
                    field.setBoolean(this.data.getData(), (Boolean)value);
                }
            }
            catch (IllegalArgumentException e) {
                EncogWorkBench.displayError("Error Setting Value: " + this.data.getFieldName(row), e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new WorkBenchError(e);
            }
        }
    }

    public Object getData() {
        return this.data;
    }

    public void updateListeners() {
        TableModelEvent event = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }
}

