/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.wizard;

import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.EncogCommonDialog;
import org.encog.workbench.dialogs.common.ValidationException;
import org.encog.workbench.dialogs.wizard.WizardType;

public class ChooseWizardDialog
extends EncogCommonDialog
implements ListSelectionListener {
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private JTextArea text = new JTextArea();
    private JScrollPane scroll1 = new JScrollPane(this.list);
    private JScrollPane scroll2 = new JScrollPane(this.text);
    private WizardType type;

    public ChooseWizardDialog() {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.setTitle("Choose a Wizard");
        this.setSize(500, 250);
        this.setLocation(50, 100);
        JPanel content = this.getBodyPanel();
        content.setLayout(new GridLayout(1, 2));
        content.add(this.scroll1);
        content.add(this.scroll2);
        this.model.addElement("Analyst Wizard");
        this.model.addElement("Realtime Analyst Wizard");
        this.list.addListSelectionListener(this);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setEditable(false);
        this.scroll2.setHorizontalScrollBarPolicy(31);
        this.type = WizardType.AnalystWizard;
    }

    @Override
    public void collectFields() throws ValidationException {
        switch (this.list.getSelectedIndex()) {
            case 0: {
                this.type = WizardType.AnalystWizard;
                break;
            }
            case 1: {
                this.type = WizardType.RealTimeAnalystWizard;
            }
        }
    }

    @Override
    public void setFields() {
        switch (this.type) {
            case AnalystWizard: {
                this.list.setSelectedIndex(0);
                break;
            }
            case RealTimeAnalystWizard: {
                this.list.setSelectedIndex(1);
            }
        }
    }

    public WizardType getTheType() {
        return this.type;
    }

    public void setType(WizardType type) {
        this.type = type;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        switch (this.list.getSelectedIndex()) {
            case 0: {
                this.text.setText("Encog Analyst Wizard allows you to create a Encog Analyst project from a CSV file.  Data can be automatically normalized and split into training sets.");
                break;
            }
            case 1: {
                this.text.setText("Real-Time Encog Analyst Wizard is used to create an Encog Analyst project for dealing with real-time collected data.  This is typically used with Encog cloud connections to Ninjatrader and others.");
            }
        }
        this.text.setSelectionStart(0);
        this.text.setSelectionEnd(0);
    }
}

