/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.validate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.encog.ml.MLClassification;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ResultValidationChart
extends EncogCommonTab {
    private static final long serialVersionUID = -2859655432840760344L;
    private JTabbedPane tabs = new JTabbedPane();
    private ArrayList<JFreeChart> charts = new ArrayList();
    private ArrayList<ChartPanel> chartPanels = new ArrayList();

    public ResultValidationChart() {
        super((ProjectFile)null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
    }

    public void setData(MLDataSet validationData, MLMethod method) {
        ArrayList<XYSeries> validation = new ArrayList<XYSeries>();
        ArrayList<XYSeries> computation = new ArrayList<XYSeries>();
        Vector<Vector<String>> tableData = new Vector<Vector<String>>();
        Vector<String> tableHeaders = null;
        int key = 0;
        for (MLDataPair dataRow : validationData) {
            int i;
            MLData input = dataRow.getInput();
            MLData validIdeal = dataRow.getIdeal();
            MLData computatedIdeal = this.getCalculatedResult(dataRow, method);
            int inputCount = input.size();
            int idealCount = validIdeal == null ? 0 : validIdeal.size();
            Vector<String> tableDataRow = new Vector<String>();
            if (tableHeaders == null) {
                tableHeaders = new Vector<String>();
                i = 0;
                while (i < inputCount) {
                    tableHeaders.add("Input " + i);
                    ++i;
                }
                i = 0;
                while (i < computatedIdeal.size()) {
                    tableHeaders.add("Ideal " + i);
                    tableHeaders.add("Result " + i);
                    ++i;
                }
            }
            i = 0;
            while (i < inputCount) {
                tableDataRow.add(new Double(input.getData(i)).toString());
                ++i;
            }
            i = validation.size();
            while (i < idealCount) {
                validation.add(new XYSeries((Comparable)((Object)"Validation")));
                computation.add(new XYSeries((Comparable)((Object)"Computation")));
                this.createChart();
                ++i;
            }
            i = 0;
            while (i < computatedIdeal.size()) {
                double c = computatedIdeal.getData(i);
                if (idealCount > 0) {
                    double v = validIdeal.getData(i);
                    validation.get(i).add((double)key, v);
                    tableDataRow.add(new Double(v).toString());
                    computation.get(i).add((double)key, c);
                } else {
                    tableDataRow.add("N/A");
                }
                tableDataRow.add(new Double(c).toString());
                ++i;
            }
            tableData.add(tableDataRow);
            ++key;
        }
        this.drawGraphs(validation, computation);
        this.drawTable(tableData, tableHeaders);
    }

    private void drawGraphs(ArrayList<XYSeries> validation, ArrayList<XYSeries> computation) {
        int size = validation.size();
        int i = 0;
        while (i < size) {
            XYSeries vSeries = validation.get(i);
            XYSeries cSeries = computation.get(i);
            JFreeChart chart = this.charts.get(i);
            ChartPanel chartPanel = this.chartPanels.get(i);
            XYPlot plot = chart.getXYPlot();
            plot.setDataset(0, (XYDataset)new XYSeriesCollection(vSeries));
            StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
            renderer1.setSeriesPaint(0, (Paint)Color.blue);
            plot.setRenderer(0, (XYItemRenderer)renderer1);
            plot.setDataset(1, (XYDataset)new XYSeriesCollection(cSeries));
            StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
            renderer2.setSeriesPaint(0, (Paint)Color.red);
            plot.setRenderer(1, (XYItemRenderer)renderer2);
            ChartUtilities.applyCurrentTheme((JFreeChart)chart);
            this.tabs.addTab("Ideal" + (i + 1), (Component)chartPanel);
            ++i;
        }
    }

    private void drawTable(Vector<Vector<String>> tableData, Vector<String> tableHeaders) {
        JTable table = new JTable(tableData, tableHeaders){
            private static final long serialVersionUID = 8364655578079933961L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        table.setAutoResizeMode(0);
        this.tabs.addTab("Data", new JScrollPane(table));
    }

    private MLData getCalculatedResult(MLDataPair data, MLMethod method) {
        MLData out;
        if (method instanceof MLRegression) {
            out = ((MLRegression)method).compute(data.getInput());
        } else if (method instanceof MLClassification) {
            out = new BasicMLData(1);
            out.setData(0, ((MLClassification)method).classify(data.getInput()));
        } else {
            throw new WorkBenchError("Unsupported Machine Learning Method:" + method.getClass().getSimpleName());
        }
        return out;
    }

    private void createChart() {
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Result", (String)"Increment", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(600, 360));
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
        this.charts.add(chart);
        this.chartPanels.add(chartPanel);
    }

    @Override
    public String getName() {
        return "Validation";
    }
}

