/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.text;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class BagOfWords {
    private final Map<String, Integer> words = new HashMap<String, Integer>();
    private boolean breakSpaces = true;
    private boolean ignoreCase = true;
    private int totalWords;
    private final int k;
    private int laplaceClasses;

    public BagOfWords(int laplace) {
        this.k = laplace;
    }

    public BagOfWords() {
        this(0);
    }

    public void process(String str) {
        if (this.breakSpaces) {
            this.processSpaces(str);
        } else {
            this.increase(str);
        }
    }

    private void processSpaces(String str) {
        StringBuilder word = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch != '\'' && !Character.isLetterOrDigit(ch)) {
                if (word.length() > 0) {
                    this.increase(word.toString());
                    word.setLength(0);
                }
            } else {
                word.append(ch);
            }
            ++i;
        }
        if (word.length() > 0) {
            this.increase(word.toString());
        }
    }

    public void increase(String word) {
        ++this.totalWords;
        ++this.laplaceClasses;
        String word2 = this.ignoreCase ? word.toLowerCase() : word;
        if (this.words.containsKey(word2)) {
            int i = this.words.get(word2);
            this.words.put(word2, ++i);
        } else {
            this.words.put(word2, 1);
        }
    }

    public boolean isBreakSpaces() {
        return this.breakSpaces;
    }

    public void setBreakSpaces(boolean breakSpaces) {
        this.breakSpaces = breakSpaces;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Map<String, Integer> getWords() {
        return this.words;
    }

    public void clear() {
        this.words.clear();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.words.keySet());
        for (String key : set) {
            int i = this.words.get(key);
            result.append(key);
            result.append(",");
            result.append(i);
            result.append("\n");
        }
        return result.toString();
    }

    public boolean contains(String word) {
        return this.words.containsKey(word);
    }

    public int getK() {
        return this.k;
    }

    public int getTotalWords() {
        return this.totalWords;
    }

    public int getCount(String word) {
        String word2 = this.ignoreCase ? word.toLowerCase() : word;
        if (!this.words.containsKey(word2)) {
            return 0;
        }
        return this.words.get(word2);
    }

    public double probability(String word) {
        double n = (double)this.getCount(word) + (double)this.k;
        double d = (double)this.getTotalWords() + (double)(this.k * this.laplaceClasses);
        return n / d;
    }

    public int getLaplaceClasses() {
        return this.laplaceClasses;
    }

    public void setLaplaceClasses(int laplaceClasses) {
        this.laplaceClasses = laplaceClasses;
    }

    public void setTotalWords(int totalWords) {
        this.totalWords = totalWords;
    }

    public int getUniqueWords() {
        return this.words.size();
    }
}

