/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.obj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.encog.EncogError;

public final class SerializeObject {
    public static Serializable load(File filename) throws IOException, ClassNotFoundException {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        fis = new FileInputStream(filename);
        in = new ObjectInputStream(fis);
        Serializable object = (Serializable)in.readObject();
        in.close();
        return object;
    }

    public static void save(File filename, Serializable object) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(filename);
        out = new ObjectOutputStream(fos);
        out.writeObject(object);
        out.close();
    }

    public static Serializable serializeClone(Serializable source) {
        try {
            ByteArrayOutputStream store = new ByteArrayOutputStream();
            ObjectOutputStream serializeOut = new ObjectOutputStream(store);
            serializeOut.writeObject(source);
            serializeOut.close();
            ByteArrayInputStream readStore = new ByteArrayInputStream(store.toByteArray());
            ObjectInputStream serializeIn = new ObjectInputStream(readStore);
            Serializable result = (Serializable)serializeIn.readObject();
            serializeIn.close();
            return result;
        }
        catch (IOException ex) {
            throw new EncogError(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new EncogError(ex);
        }
    }

    private SerializeObject() {
    }
}

