/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.datastruct;

import org.encog.EncogError;

public class StackObject<T> {
    private Object[] stack;
    private int head = 0;

    public StackObject(int size) {
        this.stack = new Object[size];
    }

    public boolean isEmpty() {
        return this.head == 0;
    }

    public void push(T str) {
        if (this.head == this.stack.length) {
            throw new EncogError("Stack overflow");
        }
        this.stack[this.head++] = str;
    }

    public T pop() {
        if (this.head == 0) {
            throw new EncogError("Stack is empty");
        }
        return (T)this.stack[--this.head];
    }

    public T peek() {
        if (this.head == 0) {
            throw new EncogError("Stack is empty");
        }
        return (T)this.stack[this.head - 1];
    }

    public int size() {
        return this.head;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[StackString: ");
        int i = this.head - 1;
        while (i >= 0) {
            result.append(this.stack[i]);
            result.append(" ");
            --i;
        }
        result.append("]");
        return result.toString();
    }
}

