/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.encog.util.csv.CSVError;

public class CSVFormat
implements Serializable {
    public static final CSVFormat DECIMAL_POINT = new CSVFormat('.', ',');
    public static final CSVFormat DECIMAL_COMMA = new CSVFormat(',', ';');
    public static final CSVFormat ENGLISH = DECIMAL_POINT;
    public static final CSVFormat EG_FORMAT = DECIMAL_POINT;
    private final char decimal;
    private final char separator;
    private final NumberFormat numberFormatter;

    public static char getDecimalCharacter() {
        return DecimalFormatSymbols.getInstance().getDecimalSeparator();
    }

    public CSVFormat() {
        this('.', ',');
    }

    public CSVFormat(char decimal, char separator) {
        this.decimal = decimal;
        this.separator = separator;
        this.numberFormatter = decimal == '.' ? NumberFormat.getInstance(Locale.US) : (decimal == ',' ? NumberFormat.getInstance(Locale.FRANCE) : NumberFormat.getInstance());
    }

    public synchronized String format(double d, int digits) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "0";
        }
        this.numberFormatter.setGroupingUsed(false);
        this.numberFormatter.setMaximumFractionDigits(digits);
        return this.numberFormatter.format(d);
    }

    public char getDecimal() {
        return this.decimal;
    }

    public NumberFormat getNumberFormatter() {
        return this.numberFormatter;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean isValid(String str) {
        block5: {
            block4: {
                try {
                    if (!str.equals("?")) break block4;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (!str.equalsIgnoreCase("NaN")) break block5;
            return false;
        }
        this.numberFormatter.parse(str.trim()).doubleValue();
        return true;
    }

    public synchronized double parse(String str) {
        block5: {
            block4: {
                try {
                    if (!str.equals("?")) break block4;
                    return Double.NaN;
                }
                catch (Exception e) {
                    throw new CSVError("Error:" + e.getMessage() + " on [" + str + "], decimal:" + this.decimal + ",sep: " + this.separator);
                }
            }
            if (!str.equalsIgnoreCase("NaN")) break block5;
            return Double.NaN;
        }
        return this.numberFormatter.parse(str.trim()).doubleValue();
    }
}

