/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.concurrency;

import java.util.ArrayList;
import java.util.List;
import org.encog.EncogError;
import org.encog.mathutil.IntRange;

public class DetermineWorkload {
    public static final int MIN_WORTHWHILE = 100;
    private int threadCount;
    private int workloadSize;

    public DetermineWorkload(int threads, int workloadSize) {
        if (workloadSize == 0) {
            throw new EncogError("Workload is of size zero.");
        }
        this.workloadSize = workloadSize;
        if (threads == 0) {
            long recordCount = this.workloadSize;
            int num = Runtime.getRuntime().availableProcessors();
            long workPerThread = recordCount / (long)num;
            if (workPerThread < 100L) {
                num = Math.max(1, (int)(recordCount / 100L));
            }
            this.threadCount = num;
        } else {
            this.threadCount = Math.min(threads, workloadSize);
        }
    }

    public List<IntRange> calculateWorkers() {
        ArrayList<IntRange> result = new ArrayList<IntRange>();
        int sizePerThread = this.workloadSize / this.threadCount;
        int i = 0;
        while (i < this.threadCount) {
            int low = i * sizePerThread;
            int high = i == this.threadCount - 1 ? this.workloadSize - 1 : (i + 1) * sizePerThread - 1;
            result.add(new IntRange(high, low));
            ++i;
        }
        return result;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

