/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.arrayutil;

import java.util.ArrayList;
import java.util.List;
import org.encog.EncogError;
import org.encog.util.EngineArray;

public class VectorWindow {
    private final List<double[]> window = new ArrayList<double[]>();
    private final int sliceCount;

    public VectorWindow(int theSliceCount) {
        this.sliceCount = theSliceCount;
    }

    public void add(double[] vec) {
        this.window.add((double[])vec.clone());
        while (this.window.size() > this.sliceCount) {
            this.window.remove(0);
        }
    }

    public boolean isReady() {
        return this.window.size() >= this.sliceCount;
    }

    public void copyWindow(double[] output, int startPos) {
        if (!this.isReady()) {
            throw new EncogError("Can't produce a timeslice of size " + this.sliceCount + ", there are only " + this.window.size() + " vectors loaded.");
        }
        int currentIndex = startPos;
        int i = 0;
        while (i < this.window.size()) {
            double[] source = this.window.get(i);
            EngineArray.arrayCopy(source, 0, output, currentIndex, source.length);
            currentIndex += source.length;
            ++i;
        }
    }
}

