/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class EngineArray {
    public static double[] arrayCopy(double[] input) {
        double[] result = new double[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    public static byte[] arrayCopy(byte[] input) {
        byte[] result = new byte[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    private static void arrayCopy(byte[] src, byte[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static void arrayCopy(double[] src, double[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static void arrayCopy(double[] source, float[] target) {
        int i = 0;
        while (i < source.length) {
            target[i] = (float)source[i];
            ++i;
        }
    }

    public static void arrayCopy(double[] source, int sourcePos, double[] target, int targetPos, int length) {
        System.arraycopy(source, sourcePos, target, targetPos, length);
    }

    public static double[][] arrayCopy(double[][] source) {
        double[][] result = new double[source.length][source[0].length];
        int row = 0;
        while (row < source.length) {
            System.arraycopy(source[row], 0, result[row], 0, source[0].length);
            ++row;
        }
        return result;
    }

    public static void arrayCopy(float[] source, double[] target) {
        int i = 0;
        while (i < source.length) {
            target[i] = source[i];
            ++i;
        }
    }

    public static int[] arrayCopy(int[] input) {
        int[] result = new int[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    public static void arrayCopy(int[] src, int[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static Double[] doubleToObject(double[] array) {
        Double[] result = new Double[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = new Double(array[i]);
            ++i;
        }
        return result;
    }

    public static void fill(double[] array, double value) {
        Arrays.fill(array, value);
    }

    public static void fill(float[] array, float value) {
        Arrays.fill(array, value);
    }

    public static int findStringInArray(String[] search, String searchFor) {
        int i = 0;
        while (i < search.length) {
            if (search[i].equals(searchFor)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static double[] listToDouble(Collection<?> list) {
        double[] result = new double[list.size()];
        int index = 0;
        for (Object obj : list) {
            result[index++] = (Double)obj;
        }
        return result;
    }

    public static double[] objectToDouble(Double[] array) {
        double[] result = new double[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = new Double(array[i]);
            ++i;
        }
        return result;
    }

    public static double vectorProduct(double[] a, double[] b) {
        int length = a.length;
        double value = 0.0;
        int i = 0;
        while (i < length) {
            value += a[i] * b[i];
            ++i;
        }
        return value;
    }

    private EngineArray() {
    }

    public static int indexOfLargest(double[] data) {
        int result = -1;
        int i = 0;
        while (i < data.length) {
            if (result == -1 || data[i] > data[result]) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static double min(double[] weights) {
        double result = Double.MAX_VALUE;
        int i = 0;
        while (i < weights.length) {
            result = Math.min(result, weights[i]);
            ++i;
        }
        return result;
    }

    public static double max(double[] weights) {
        double result = Double.MIN_VALUE;
        int i = 0;
        while (i < weights.length) {
            result = Math.max(result, weights[i]);
            ++i;
        }
        return result;
    }

    public static boolean contains(int[] array, int target) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == target) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int maxIndex(double[] data) {
        int result = -1;
        int i = 0;
        while (i < data.length) {
            if (result == -1 || data[i] > data[result]) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static int maxIndex(int[] data) {
        int result = -1;
        int i = 0;
        while (i < data.length) {
            if (result == -1 || data[i] > data[result]) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static int max(int[] data) {
        int result = Integer.MIN_VALUE;
        int i = 0;
        while (i < data.length) {
            result = Math.max(result, data[i]);
            ++i;
        }
        return result;
    }

    public static int min(int[] data) {
        int result = Integer.MAX_VALUE;
        int i = 0;
        while (i < data.length) {
            result = Math.min(result, data[i]);
            ++i;
        }
        return result;
    }

    public static double mean(int[] data) {
        double result = 0.0;
        int i = 0;
        while (i < data.length) {
            result += (double)data[i];
            ++i;
        }
        return result / (double)data.length;
    }

    public static double sdev(int[] data) {
        double avg = EngineArray.mean(data);
        double result = 0.0;
        int i = 0;
        while (i < data.length) {
            double diff = (double)data[i] - avg;
            result += diff * diff;
            ++i;
        }
        return Math.sqrt(result / (double)data.length);
    }

    public static double euclideanDistance(double[] p1, double[] p2) {
        double sum = 0.0;
        int i = 0;
        while (i < p1.length) {
            double d = p1[i] - p2[i];
            sum += d * d;
            ++i;
        }
        return Math.sqrt(sum);
    }

    public static void fill(double[][] sigma, int value) {
        int i = 0;
        while (i < sigma.length) {
            int j = 0;
            while (j < sigma[i].length) {
                sigma[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    public static void fill(boolean[] a, boolean b) {
        int i = 0;
        while (i < a.length) {
            a[i] = b;
            ++i;
        }
    }

    public static double[] add(double[] d, double[] m) {
        double[] result = new double[d.length];
        int i = 0;
        while (i < d.length) {
            result[i] = d[i] + m[i];
            ++i;
        }
        return result;
    }

    public static double[] subtract(double[] a, double[] b) {
        double[] result = new double[a.length];
        int i = 0;
        while (i < a.length) {
            result[i] = a[i] - b[i];
            ++i;
        }
        return result;
    }

    public static double mean(double[] data) {
        double result = 0.0;
        int i = 0;
        while (i < data.length) {
            result += data[i];
            ++i;
        }
        return result / (double)data.length;
    }

    public static void fill(int[] a, int value) {
        Arrays.fill(a, value);
    }

    public static String replace(String str, String searchFor, String replace) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            String cmp;
            boolean append = true;
            if (i + searchFor.length() < str.length() && (cmp = str.substring(i, i + searchFor.length())).equals(searchFor)) {
                i += searchFor.length() - 1;
                result.append(replace);
                append = false;
            }
            if (append) {
                result.append(str.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static void arrayCopy(byte[] source, int sourcePos, byte[] target, int targetPos, int length) {
        System.arraycopy(source, sourcePos, target, targetPos, length);
    }

    public static void arrayCopy(int[] source, int sourcePos, int[] target, int targetPos, int length) {
        System.arraycopy(source, sourcePos, target, targetPos, length);
    }

    public static void arrayAdd(double[][] target, double[][] h) {
        int row = 0;
        while (row < target.length) {
            int col = 0;
            while (col < target[row].length) {
                double[] dArray = target[row];
                int n = col;
                dArray[n] = dArray[n] + h[row][col];
                ++col;
            }
            ++row;
        }
    }

    public static List<String> string2list(String str) {
        String[] list;
        if (str == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = list = str.split(",");
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > 0) {
                result.add(s);
            }
            ++n2;
        }
        return result;
    }

    public static String list2string(List<String> list) {
        StringBuilder result = new StringBuilder();
        for (String str : list) {
            if (result.length() != 0) {
                result.append(',');
            }
            result.append(str);
        }
        return result.toString();
    }
}

