/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.encog.neural.pnn.BasicPNN;
import org.encog.neural.pnn.PNNKernelType;
import org.encog.neural.pnn.PNNOutputMode;

public class PNNPattern
implements NeuralNetworkPattern {
    private PNNKernelType kernel = PNNKernelType.Gaussian;
    private PNNOutputMode outmodel = PNNOutputMode.Regression;
    private int inputNeurons;
    private int outputNeurons;

    @Override
    public void addHiddenLayer(int count) {
        throw new PatternError("A PNN network does not have hidden layers.");
    }

    @Override
    public void clear() {
    }

    @Override
    public MLMethod generate() {
        BasicPNN pnn = new BasicPNN(this.kernel, this.outmodel, this.inputNeurons, this.outputNeurons);
        return pnn;
    }

    public int getInputNeurons() {
        return this.inputNeurons;
    }

    public PNNKernelType getKernel() {
        return this.kernel;
    }

    public PNNOutputMode getOutmodel() {
        return this.outmodel;
    }

    public int getOutputNeurons() {
        return this.outputNeurons;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("A SOM network can't define an activation function.");
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    public void setKernel(PNNKernelType kernel) {
        this.kernel = kernel;
    }

    public void setOutmodel(PNNOutputMode outmodel) {
        this.outmodel = outmodel;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

