/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.hyperneat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSteepenedSigmoid;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.ea.codec.GeneticCODEC;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.genetic.GeneticError;
import org.encog.neural.hyperneat.substrate.Substrate;
import org.encog.neural.hyperneat.substrate.SubstrateLink;
import org.encog.neural.hyperneat.substrate.SubstrateNode;
import org.encog.neural.neat.NEATCODEC;
import org.encog.neural.neat.NEATLink;
import org.encog.neural.neat.NEATNetwork;
import org.encog.neural.neat.NEATPopulation;

public class HyperNEATCODEC
implements GeneticCODEC {
    private double minWeight = 0.2;
    private double maxWeight = 5.0;

    @Override
    public MLMethod decode(Genome genome) {
        NEATPopulation pop = (NEATPopulation)genome.getPopulation();
        Substrate substrate = pop.getSubstrate();
        return this.decode(pop, substrate, genome);
    }

    public MLMethod decode(NEATPopulation pop, Substrate substrate, Genome genome) {
        NEATCODEC neatCodec = new NEATCODEC();
        NEATNetwork cppn = (NEATNetwork)neatCodec.decode(genome);
        ArrayList<NEATLink> linkList = new ArrayList<NEATLink>();
        ActivationFunction[] afs = new ActivationFunction[substrate.getNodeCount()];
        ActivationSteepenedSigmoid af = new ActivationSteepenedSigmoid();
        int i = 0;
        while (i < afs.length) {
            afs[i] = af;
            ++i;
        }
        double c = this.maxWeight / (1.0 - this.minWeight);
        BasicMLData input = new BasicMLData(cppn.getInputCount());
        for (SubstrateLink link : substrate.getLinks()) {
            double d;
            SubstrateNode source = link.getSource();
            SubstrateNode target = link.getTarget();
            int index = 0;
            double[] dArray = source.getLocation();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                d = dArray[n2];
                input.setData(index++, d);
                ++n2;
            }
            dArray = target.getLocation();
            n = dArray.length;
            n2 = 0;
            while (n2 < n) {
                d = dArray[n2];
                input.setData(index++, d);
                ++n2;
            }
            MLData output = cppn.compute(input);
            double weight = output.getData(0);
            if (!(Math.abs(weight) > this.minWeight)) continue;
            weight = (Math.abs(weight) - this.minWeight) * c * Math.signum(weight);
            linkList.add(new NEATLink(source.getId(), target.getId(), weight));
        }
        input.clear();
        int d = substrate.getDimensions();
        List<SubstrateNode> biasedNodes = substrate.getBiasedNodes();
        for (SubstrateNode target : biasedNodes) {
            int i2 = 0;
            while (i2 < d) {
                input.setData(d + i2, target.getLocation()[i2]);
                ++i2;
            }
            MLData output = cppn.compute(input);
            double biasWeight = output.getData(1);
            if (!(Math.abs(biasWeight) > this.minWeight)) continue;
            biasWeight = (Math.abs(biasWeight) - this.minWeight) * c * Math.signum(biasWeight);
            linkList.add(new NEATLink(0, target.getId(), biasWeight));
        }
        if (linkList.size() == 0) {
            return null;
        }
        Collections.sort(linkList);
        NEATNetwork network = new NEATNetwork(substrate.getInputCount(), substrate.getOutputCount(), linkList, afs);
        network.setActivationCycles(substrate.getActivationCycles());
        return network;
    }

    @Override
    public Genome encode(MLMethod phenotype) {
        throw new GeneticError("Encoding of a HyperNEAT network is not supported.");
    }

    public double getMaxWeight() {
        return this.maxWeight;
    }

    public double getMinWeight() {
        return this.minWeight;
    }

    public void setMaxWeight(double maxWeight) {
        this.maxWeight = maxWeight;
    }

    public void setMinWeight(double minWeight) {
        this.minWeight = minWeight;
    }
}

