/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.world;

import org.encog.ml.world.State;
import org.encog.ml.world.WorldError;
import org.encog.util.Format;

public class SuccessorState
implements Comparable<SuccessorState> {
    private final State state;
    private final double probability;
    private final long serialNumber;
    private static long serialCounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuccessorState(State state, double probability) {
        if (state == null) {
            throw new WorldError("Can't create null successor state");
        }
        this.state = state;
        this.probability = probability;
        Class<SuccessorState> clazz = SuccessorState.class;
        synchronized (SuccessorState.class) {
            this.serialNumber = serialCounter++;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public State getState() {
        return this.state;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public int compareTo(SuccessorState o) {
        if (o.getProbability() == this.getProbability()) {
            return o.serialNumber < this.serialNumber ? 1 : -1;
        }
        if (o.getProbability() < this.getProbability()) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[SuccessorState: state=");
        result.append(this.state.toString());
        result.append(", prob=");
        result.append(Format.formatPercent(this.probability));
        result.append("]");
        return result.toString();
    }
}

