/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy;

import org.encog.ml.MLResettable;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.networks.training.TrainingError;
import org.encog.util.logging.EncogLogging;

public class ResetStrategy
implements Strategy {
    private final double required;
    private final int cycles;
    private MLTrain train;
    private int badCycleCount;
    private MLResettable method;

    public ResetStrategy(double required, int cycles) {
        this.required = required;
        this.cycles = cycles;
        this.badCycleCount = 0;
    }

    @Override
    public void init(MLTrain train) {
        this.train = train;
        if (!(train.getMethod() instanceof MLResettable)) {
            throw new TrainingError("To use the reset strategy the machine learning method must support MLResettable.");
        }
        this.method = (MLResettable)this.train.getMethod();
    }

    @Override
    public void postIteration() {
    }

    @Override
    public void preIteration() {
        if (this.train.getError() > this.required) {
            ++this.badCycleCount;
            if (this.badCycleCount > this.cycles) {
                EncogLogging.log(0, "Failed to imrove network, resetting.");
                this.method.reset();
                this.badCycleCount = 0;
            }
        } else {
            this.badCycleCount = 0;
        }
    }
}

