/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.svm;

import org.encog.EncogError;
import org.encog.mathutil.libsvm.svm;
import org.encog.mathutil.libsvm.svm_model;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_parameter;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.svm.KernelType;
import org.encog.ml.svm.SVMType;
import org.encog.neural.NeuralNetworkError;
import org.encog.util.simple.EncogUtility;

public class SVM
extends BasicML
implements MLRegression,
MLClassification,
MLError {
    public static final int DEFAULT_DEGREE = 3;
    public static final int DEFAULT_COEF0 = 0;
    public static final double DEFAULT_NU = 0.5;
    public static final int DEFAULT_CACHE_SIZE = 100;
    public static final int DEFAULT_C = 1;
    public static final double DEFAULT_EPS = 0.001;
    public static final double DEFAULT_P = 0.1;
    private static final long serialVersionUID = 1L;
    private svm_model model;
    private final svm_parameter params;
    private int inputCount;

    public SVM() {
        this.params = new svm_parameter();
    }

    public SVM(int theInputCount, boolean regression) {
        this(theInputCount, regression ? SVMType.EpsilonSupportVectorRegression : SVMType.SupportVectorClassification, KernelType.RadialBasisFunction);
    }

    public SVM(int theInputCount, SVMType svmType, KernelType kernelType) {
        this.inputCount = theInputCount;
        this.params = new svm_parameter();
        switch (svmType) {
            case SupportVectorClassification: {
                this.params.svm_type = 0;
                break;
            }
            case NewSupportVectorClassification: {
                this.params.svm_type = 1;
                break;
            }
            case SupportVectorOneClass: {
                this.params.svm_type = 2;
                break;
            }
            case EpsilonSupportVectorRegression: {
                this.params.svm_type = 3;
                break;
            }
            case NewSupportVectorRegression: {
                this.params.svm_type = 4;
                break;
            }
            default: {
                throw new NeuralNetworkError("Invalid svm type");
            }
        }
        switch (kernelType) {
            case Linear: {
                this.params.kernel_type = 0;
                break;
            }
            case Poly: {
                this.params.kernel_type = 1;
                break;
            }
            case RadialBasisFunction: {
                this.params.kernel_type = 2;
                break;
            }
            case Sigmoid: {
                this.params.kernel_type = 3;
                break;
            }
            case Precomputed: {
                this.params.kernel_type = 4;
                break;
            }
            default: {
                throw new NeuralNetworkError("Invalid kernel type");
            }
        }
        this.params.degree = 3;
        this.params.coef0 = 0.0;
        this.params.nu = 0.5;
        this.params.cache_size = 100.0;
        this.params.C = 1.0;
        this.params.eps = 0.001;
        this.params.p = 0.1;
        this.params.shrinking = 1;
        this.params.probability = 0;
        this.params.nr_weight = 0;
        this.params.weight_label = new int[0];
        this.params.weight = new double[0];
        this.params.gamma = 1.0 / (double)this.inputCount;
    }

    public SVM(svm_model theModel) {
        this.model = theModel;
        this.params = this.model.param;
        this.inputCount = 0;
        svm_node[][] svm_nodeArray = this.model.SV;
        int n = this.model.SV.length;
        int n2 = 0;
        while (n2 < n) {
            svm_node[] element = svm_nodeArray[n2];
            int col = 0;
            while (col < element.length) {
                this.inputCount = Math.max(element[col].index, this.inputCount);
                ++col;
            }
            ++n2;
        }
    }

    @Override
    public double calculateError(MLDataSet data) {
        switch (this.getSVMType()) {
            case SupportVectorClassification: 
            case NewSupportVectorClassification: 
            case SupportVectorOneClass: {
                return EncogUtility.calculateClassificationError(this, data);
            }
            case EpsilonSupportVectorRegression: 
            case NewSupportVectorRegression: {
                return EncogUtility.calculateRegressionError(this, data);
            }
        }
        return EncogUtility.calculateRegressionError(this, data);
    }

    @Override
    public int classify(MLData input) {
        if (this.model == null) {
            throw new EncogError("Can't use the SVM yet, it has not been trained, and no model exists.");
        }
        svm_node[] formattedInput = this.makeSparse(input);
        return (int)svm.svm_predict(this.model, formattedInput);
    }

    @Override
    public MLData compute(MLData input) {
        if (this.model == null) {
            throw new EncogError("Can't use the SVM yet, it has not been trained, and no model exists.");
        }
        BasicMLData result = new BasicMLData(1);
        svm_node[] formattedInput = this.makeSparse(input);
        double d = svm.svm_predict(this.model, formattedInput);
        result.setData(0, d);
        return result;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public KernelType getKernelType() {
        switch (this.params.kernel_type) {
            case 0: {
                return KernelType.Linear;
            }
            case 1: {
                return KernelType.Poly;
            }
            case 2: {
                return KernelType.RadialBasisFunction;
            }
            case 3: {
                return KernelType.Sigmoid;
            }
            case 4: {
                return KernelType.Precomputed;
            }
        }
        return null;
    }

    public svm_model getModel() {
        return this.model;
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    public final svm_parameter getParams() {
        return this.params;
    }

    public SVMType getSVMType() {
        switch (this.params.svm_type) {
            case 0: {
                return SVMType.SupportVectorClassification;
            }
            case 1: {
                return SVMType.NewSupportVectorClassification;
            }
            case 2: {
                return SVMType.SupportVectorOneClass;
            }
            case 3: {
                return SVMType.EpsilonSupportVectorRegression;
            }
            case 4: {
                return SVMType.NewSupportVectorRegression;
            }
        }
        return null;
    }

    public svm_node[] makeSparse(MLData data) {
        svm_node[] result = new svm_node[data.size()];
        int i = 0;
        while (i < data.size()) {
            result[i] = new svm_node();
            result[i].index = i + 1;
            result[i].value = data.getData(i);
            ++i;
        }
        return result;
    }

    public void setInputCount(int i) {
        this.inputCount = i;
    }

    public void setModel(svm_model theModel) {
        this.model = theModel;
    }

    @Override
    public void updateProperties() {
    }
}

