/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.train.rewrite;

import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.rules.RewriteRule;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.StandardExtensions;

public class RewriteBoolean
implements RewriteRule {
    private boolean rewritten;

    private boolean isTrue(ProgramNode node) {
        ExpressionValue v;
        return node.getTemplate() == StandardExtensions.EXTENSION_CONST_SUPPORT && (v = node.evaluate()).isBoolean() && v.toBooleanValue();
    }

    private boolean isFalse(ProgramNode node) {
        ExpressionValue v;
        return node.getTemplate() == StandardExtensions.EXTENSION_CONST_SUPPORT && (v = node.evaluate()).isBoolean() && !v.toBooleanValue();
    }

    @Override
    public boolean rewrite(Genome g) {
        this.rewritten = false;
        EncogProgram program = (EncogProgram)g;
        ProgramNode node = program.getRootNode();
        ProgramNode rewrittenRoot = this.internalRewrite(node);
        if (rewrittenRoot != null) {
            program.setRootNode(rewrittenRoot);
        }
        return this.rewritten;
    }

    private ProgramNode internalRewrite(ProgramNode parent) {
        ProgramNode rewrittenParent = parent;
        rewrittenParent = this.tryAnd(rewrittenParent);
        int i = 0;
        while (i < rewrittenParent.getChildNodes().size()) {
            ProgramNode rewriteChild;
            ProgramNode childNode = (ProgramNode)rewrittenParent.getChildNodes().get(i);
            if (childNode != (rewriteChild = this.internalRewrite(childNode))) {
                rewrittenParent.getChildNodes().remove(i);
                rewrittenParent.getChildNodes().add(i, rewriteChild);
                this.rewritten = true;
            }
            ++i;
        }
        return rewrittenParent;
    }

    private ProgramNode tryAnd(ProgramNode parent) {
        if (parent.getTemplate() == StandardExtensions.EXTENSION_AND) {
            ProgramNode child1 = parent.getChildNode(0);
            ProgramNode child2 = parent.getChildNode(1);
            if (this.isTrue(child1) && child2.getTemplate() != StandardExtensions.EXTENSION_CONST_SUPPORT) {
                this.rewritten = true;
                return child2;
            }
            if (this.isTrue(child2) && child1.getTemplate() != StandardExtensions.EXTENSION_CONST_SUPPORT) {
                this.rewritten = true;
                return child1;
            }
        }
        return parent;
    }
}

