/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.species.BasicSpecies;
import org.encog.ml.ea.species.Species;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.VariableMapping;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.util.csv.CSVFormat;

public class PersistPrgPopulation
implements EncogPersistor {
    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return "PrgPopulation";
    }

    private String getType(VariableMapping mapping) {
        switch (mapping.getVariableType()) {
            case floatingType: {
                return "f";
            }
            case stringType: {
                return "s";
            }
            case booleanType: {
                return "b";
            }
            case intType: {
                return "i";
            }
            case enumType: {
                return "e";
            }
        }
        throw new EncogError("Unknown type: " + mapping.getVariableType().toString());
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        EncogProgramContext context = new EncogProgramContext();
        PrgPopulation result = new PrgPopulation(context, 0);
        EncogReadHelper in = new EncogReadHelper(is);
        int count = 0;
        BasicSpecies lastSpecies = null;
        while ((section = in.readNextSection()) != null) {
            List<String> cols;
            if (section.getSectionName().equals("BASIC") && section.getSubSectionName().equals("PARAMS")) {
                Map<String, String> params = section.parseParams();
                result.getProperties().putAll(params);
                continue;
            }
            if (section.getSectionName().equals("BASIC") && section.getSubSectionName().equals("EPL-POPULATION")) {
                for (String line : section.getLines()) {
                    cols = EncogFileSection.splitColumns(line);
                    if (cols.get(0).equalsIgnoreCase("s")) {
                        lastSpecies = new BasicSpecies();
                        lastSpecies.setAge(Integer.parseInt(cols.get(1)));
                        lastSpecies.setBestScore(CSVFormat.EG_FORMAT.parse(cols.get(2)));
                        lastSpecies.setPopulation(result);
                        lastSpecies.setGensNoImprovement(Integer.parseInt(cols.get(3)));
                        result.getSpecies().add(lastSpecies);
                        continue;
                    }
                    if (!cols.get(0).equalsIgnoreCase("p")) continue;
                    double score = 0.0;
                    double adjustedScore = 0.0;
                    if (cols.get(1).equalsIgnoreCase("nan") || cols.get(2).equalsIgnoreCase("nan")) {
                        score = Double.NaN;
                        adjustedScore = Double.NaN;
                    } else {
                        score = CSVFormat.EG_FORMAT.parse(cols.get(1));
                        adjustedScore = CSVFormat.EG_FORMAT.parse(cols.get(2));
                    }
                    String code = cols.get(3);
                    EncogProgram prg = new EncogProgram(context);
                    prg.compileEPL(code);
                    prg.setScore(score);
                    prg.setSpecies(lastSpecies);
                    prg.setAdjustedScore(adjustedScore);
                    if (lastSpecies == null) {
                        throw new EncogError("Have not defined a species yet");
                    }
                    lastSpecies.add(prg);
                    ++count;
                }
                continue;
            }
            if (section.getSectionName().equals("BASIC") && section.getSubSectionName().equals("EPL-OPCODES")) {
                for (String line : section.getLines()) {
                    cols = EncogFileSection.splitColumns(line);
                    String name = cols.get(0);
                    int args = Integer.parseInt(cols.get(1));
                    result.getContext().getFunctions().addExtension(name, args);
                }
                continue;
            }
            if (!section.getSectionName().equals("BASIC") || !section.getSubSectionName().equals("EPL-SYMBOLIC")) continue;
            boolean first = true;
            for (String line : section.getLines()) {
                if (!first) {
                    List<String> cols2 = EncogFileSection.splitColumns(line);
                    String name = cols2.get(0);
                    String t = cols2.get(1);
                    ValueType vt = null;
                    if (t.equalsIgnoreCase("f")) {
                        vt = ValueType.floatingType;
                    } else if (t.equalsIgnoreCase("b")) {
                        vt = ValueType.booleanType;
                    } else if (t.equalsIgnoreCase("i")) {
                        vt = ValueType.intType;
                    } else if (t.equalsIgnoreCase("s")) {
                        vt = ValueType.stringType;
                    } else if (t.equalsIgnoreCase("e")) {
                        vt = ValueType.enumType;
                    }
                    int enumType = Integer.parseInt(cols2.get(2));
                    int enumCount = Integer.parseInt(cols2.get(3));
                    VariableMapping mapping = new VariableMapping(name, vt, enumType, enumCount);
                    if (mapping.getName().length() > 0) {
                        result.getContext().defineVariable(mapping);
                        continue;
                    }
                    result.getContext().setResult(mapping);
                    continue;
                }
                first = false;
            }
        }
        result.setPopulationSize(count);
        if (result.getSpecies().size() > 0) {
            Species species = result.getSpecies().get(0);
            if (species.getMembers().size() > 0) {
                result.setBestGenome(species.getMembers().get(0));
            }
            for (Species sp : result.getSpecies()) {
                if (sp.getMembers().size() <= 0) continue;
                sp.setLeader(sp.getMembers().get(0));
            }
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        PrgPopulation pop = (PrgPopulation)obj;
        out.addSection("BASIC");
        out.addSubSection("PARAMS");
        out.addProperties(pop.getProperties());
        out.addSubSection("EPL-OPCODES");
        for (ProgramExtensionTemplate temp : pop.getContext().getFunctions().getOpCodes()) {
            out.addColumn(temp.getName());
            out.addColumn(temp.getChildNodeCount());
            out.writeLine();
        }
        out.addSubSection("EPL-SYMBOLIC");
        out.addColumn("name");
        out.addColumn("type");
        out.addColumn("enum");
        out.addColumn("enum_type");
        out.addColumn("enum_count");
        out.writeLine();
        out.addColumn("");
        out.addColumn(this.getType(pop.getContext().getResult()));
        out.addColumn(pop.getContext().getResult().getEnumType());
        out.addColumn(pop.getContext().getResult().getEnumValueCount());
        out.writeLine();
        for (VariableMapping mapping : pop.getContext().getDefinedVariables()) {
            out.addColumn(mapping.getName());
            out.addColumn(this.getType(mapping));
            out.addColumn(mapping.getEnumType());
            out.addColumn(mapping.getEnumValueCount());
            out.writeLine();
        }
        out.addSubSection("EPL-POPULATION");
        for (Species species : pop.getSpecies()) {
            if (species.getMembers().size() <= 0) continue;
            out.addColumn("s");
            out.addColumn(species.getAge());
            out.addColumn(species.getBestScore());
            out.addColumn(species.getGensNoImprovement());
            out.writeLine();
            for (Genome genome : species.getMembers()) {
                EncogProgram prg = (EncogProgram)genome;
                out.addColumn("p");
                if (Double.isInfinite(prg.getScore()) || Double.isNaN(prg.getScore())) {
                    out.addColumn("NaN");
                    out.addColumn("NaN");
                } else {
                    out.addColumn(prg.getScore());
                    out.addColumn(prg.getAdjustedScore());
                }
                out.addColumn(prg.generateEPL());
                out.writeLine();
            }
        }
        out.flush();
    }
}

