/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.kmeans;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.MLCluster;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataPairCentroid;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.util.kmeans.Centroid;
import org.encog.util.kmeans.Cluster;

public class BasicCluster
implements MLCluster {
    private BasicMLDataPairCentroid centroid;
    private final List<MLData> data = new ArrayList<MLData>();

    public BasicCluster(Cluster<BasicMLDataPair> cluster) {
        this.centroid = (BasicMLDataPairCentroid)cluster.centroid();
        for (MLDataPair mLDataPair : cluster.getContents()) {
            this.data.add(mLDataPair.getInput());
        }
    }

    @Override
    public final void add(MLData pair) {
        this.data.add(pair);
    }

    @Override
    public final MLDataSet createDataSet() {
        BasicMLDataSet result = new BasicMLDataSet();
        for (MLData dataItem : this.data) {
            result.add(dataItem);
        }
        return result;
    }

    @Override
    public final MLData get(int pos) {
        return this.data.get(pos);
    }

    public final Centroid<?> getCentroid() {
        return this.centroid;
    }

    @Override
    public final List<MLData> getData() {
        return this.data;
    }

    @Override
    public final void remove(MLData pair) {
        this.data.remove(pair);
    }

    public final void setCentroid(BasicMLDataPairCentroid c) {
        this.centroid = c;
    }

    @Override
    public final int size() {
        return this.data.size();
    }
}

