/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.importance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.encog.EncogError;
import org.encog.ml.MLRegression;
import org.encog.ml.importance.FeatureImportance;
import org.encog.ml.importance.FeatureRank;

public abstract class AbstractFeatureImportance
implements FeatureImportance {
    private MLRegression model;
    private final List<FeatureRank> features = new ArrayList<FeatureRank>();

    @Override
    public void init(MLRegression theModel, String[] theFeatureNames) {
        this.model = theModel;
        if (theFeatureNames == null) {
            int i = 0;
            while (i < this.model.getInputCount()) {
                this.features.add(new FeatureRank("f" + i));
                ++i;
            }
        } else {
            if (this.model != null && theFeatureNames.length != this.model.getInputCount()) {
                throw new EncogError("Neural network inputs(" + this.model.getInputCount() + ") and feature name count(" + theFeatureNames.length + ") do not match.");
            }
            String[] stringArray = theFeatureNames;
            int n = theFeatureNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.features.add(new FeatureRank(name));
                ++n2;
            }
        }
    }

    @Override
    public List<FeatureRank> getFeatures() {
        return this.features;
    }

    @Override
    public Collection<FeatureRank> getFeaturesSorted() {
        TreeSet<FeatureRank> result = new TreeSet<FeatureRank>();
        result.addAll(this.features);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (FeatureRank ranking : this.getFeaturesSorted()) {
            int idx = this.getFeatures().indexOf(ranking);
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(idx);
        }
        return result.toString();
    }

    @Override
    public MLRegression getModel() {
        return this.model;
    }
}

