/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.util.kmeans.Centroid;

public class BasicMLDataPairCentroid
implements Centroid<MLDataPair>,
Cloneable {
    private BasicMLData value;
    private int size;

    public BasicMLDataPairCentroid(BasicMLDataPair o) {
        this.value = (BasicMLData)o.getInput().clone();
        this.size = 1;
    }

    @Override
    public void remove(MLDataPair d) {
        double[] a = d.getInputArray();
        int i = 0;
        while (i < this.value.size()) {
            this.value.setData(i, (this.value.getData(i) * (double)this.value.size() - a[i]) / (double)(this.value.size() - 1));
            ++i;
        }
    }

    @Override
    public double distance(MLDataPair d) {
        MLData diff = this.value.minus(d.getInput());
        double sum = 0.0;
        int i = 0;
        while (i < diff.size()) {
            sum += diff.getData(i) * diff.getData(i);
            ++i;
        }
        return Math.sqrt(sum);
    }

    @Override
    public void add(MLDataPair d) {
        double[] a = d.getInputArray();
        int i = 0;
        while (i < this.value.size()) {
            this.value.setData(i, (this.value.getData(i) * (double)this.value.size() + a[i]) / (double)(this.value.size() + 1));
            ++i;
        }
    }
}

