/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.query.sample;

import java.io.Serializable;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.query.BasicQuery;
import org.encog.ml.bayesian.query.sample.EventState;
import org.encog.util.Format;

public class SamplingQuery
extends BasicQuery
implements Serializable {
    public static final int DEFAULT_SAMPLE_SIZE = 100000;
    private int sampleSize = 100000;
    private int usableSamples;
    private int goodSamples;
    private int totalSamples;

    public SamplingQuery(BayesianNetwork theNetwork) {
        super(theNetwork);
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    private int[] obtainArgs(BayesianEvent event) {
        int[] result = new int[event.getParents().size()];
        int index = 0;
        for (BayesianEvent parentEvent : event.getParents()) {
            EventState state = this.getEventState(parentEvent);
            if (!state.isCalculated()) {
                return null;
            }
            result[index++] = state.getValue();
        }
        return result;
    }

    private void randomizeEvents(EventState eventState) {
        int[] args;
        if (!eventState.isCalculated() && (args = this.obtainArgs(eventState.getEvent())) != null) {
            eventState.randomize(args);
        }
        for (BayesianEvent childEvent : eventState.getEvent().getChildren()) {
            this.randomizeEvents(this.getEventState(childEvent));
        }
    }

    private int countUnCalculated() {
        int result = 0;
        for (EventState state : this.getEvents().values()) {
            if (state.isCalculated()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void execute() {
        this.locateEventTypes();
        this.usableSamples = 0;
        this.goodSamples = 0;
        this.totalSamples = 0;
        int i = 0;
        while (i < this.sampleSize) {
            int uncalculated;
            this.reset();
            int lastUncalculated = Integer.MAX_VALUE;
            do {
                for (EventState state : this.getEvents().values()) {
                    this.randomizeEvents(state);
                }
                uncalculated = this.countUnCalculated();
                if (uncalculated == lastUncalculated) {
                    throw new BayesianError("Unable to calculate all nodes in the graph.");
                }
                lastUncalculated = uncalculated;
            } while (uncalculated > 0);
            ++this.totalSamples;
            if (this.isNeededEvidence()) {
                ++this.usableSamples;
                if (this.satisfiesDesiredOutcome()) {
                    ++this.goodSamples;
                }
            }
            ++i;
        }
    }

    @Override
    public double getProbability() {
        return (double)this.goodSamples / (double)this.usableSamples;
    }

    public String dumpCurrentState() {
        StringBuilder result = new StringBuilder();
        for (EventState state : this.getEvents().values()) {
            result.append(state.toString());
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public SamplingQuery clone() {
        return new SamplingQuery(this.getNetwork());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[SamplingQuery: ");
        result.append(this.getProblem());
        result.append("=");
        result.append(Format.formatPercent(this.getProbability()));
        result.append(" ;good/usable=");
        result.append(Format.formatInteger(this.goodSamples));
        result.append("/");
        result.append(Format.formatInteger(this.usableSamples));
        result.append(";totalSamples=");
        result.append(Format.formatInteger(this.totalSamples));
        return result.toString();
    }
}

