/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.rbf;

import org.encog.mathutil.BoundMath;
import org.encog.mathutil.rbf.BasicRBF;

public class InverseMultiquadricFunction
extends BasicRBF {
    private static final long serialVersionUID = 1L;

    public InverseMultiquadricFunction(double center, double peak, double width) {
        this.setCenters(new double[1]);
        this.getCenters()[0] = center;
        this.setPeak(peak);
        this.setWidth(width);
    }

    public InverseMultiquadricFunction(double peak, double[] center, double width) {
        this.setCenters(center);
        this.setPeak(peak);
        this.setWidth(width);
    }

    public InverseMultiquadricFunction(int dimensions) {
        this.setCenters(new double[dimensions]);
        this.setPeak(1.0);
        this.setWidth(1.0);
    }

    @Override
    public final double calculate(double[] x) {
        double value = 0.0;
        double[] center = this.getCenters();
        double width = this.getWidth();
        int i = 0;
        while (i < center.length) {
            value += Math.pow(x[i] - center[i], 2.0) + width * width;
            ++i;
        }
        return this.getPeak() / BoundMath.sqrt(value);
    }
}

