/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.mathutil.randomize.generate.LinearCongruentialRandom;
import org.encog.neural.networks.BasicNetwork;

public class ConsistentRandomizer
extends BasicRandomizer {
    private LinearCongruentialRandom rand;
    private final double min;
    private final double max;
    private final int seed;

    public ConsistentRandomizer(double min, double max) {
        this(min, max, 1000);
    }

    public ConsistentRandomizer(double min, double max, int seed) {
        this.max = max;
        this.min = min;
        this.seed = seed;
        this.rand = new LinearCongruentialRandom(seed);
    }

    @Override
    public double randomize(double d) {
        return this.rand.nextDouble(this.min, this.max);
    }

    public void randomize(BasicNetwork network) {
        this.rand = new LinearCongruentialRandom(this.seed);
        super.randomize(network);
    }
}

