/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.Randomizer;
import org.encog.mathutil.randomize.generate.GenerateRandom;
import org.encog.mathutil.randomize.generate.MersenneTwisterGenerateRandom;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;

public abstract class BasicRandomizer
implements Randomizer {
    private GenerateRandom random = new MersenneTwisterGenerateRandom(System.nanoTime());

    @Override
    public final GenerateRandom getRandom() {
        return this.random;
    }

    public final double nextDouble() {
        return this.random.nextDouble();
    }

    public final double nextDouble(double min, double max) {
        double range = max - min;
        return range * this.random.nextDouble() + min;
    }

    public void randomize(BasicNetwork network, int fromLayer) {
        int fromCount = network.getLayerTotalNeuronCount(fromLayer);
        int toCount = network.getLayerNeuronCount(fromLayer + 1);
        int fromNeuron = 0;
        while (fromNeuron < fromCount) {
            int toNeuron = 0;
            while (toNeuron < toCount) {
                double v = network.getWeight(fromLayer, fromNeuron, toNeuron);
                v = this.randomize(v);
                network.setWeight(fromLayer, fromNeuron, toNeuron, v);
                ++toNeuron;
            }
            ++fromNeuron;
        }
    }

    @Override
    public void randomize(double[] d) {
        this.randomize(d, 0, d.length);
    }

    @Override
    public void randomize(double[] d, int begin, int size) {
        int i = 0;
        while (i < size) {
            d[begin + i] = this.randomize(d[begin + i]);
            ++i;
        }
    }

    @Override
    public void randomize(double[][] d) {
        int r = 0;
        while (r < d.length) {
            int c = 0;
            while (c < d[0].length) {
                d[r][c] = this.randomize(d[r][c]);
                ++c;
            }
            ++r;
        }
    }

    @Override
    public void randomize(Matrix m) {
        double[][] d = m.getData();
        int r = 0;
        while (r < m.getRows()) {
            int c = 0;
            while (c < m.getCols()) {
                d[r][c] = this.randomize(d[r][c]);
                ++c;
            }
            ++r;
        }
    }

    @Override
    public void randomize(MLMethod method) {
        if (method instanceof BasicNetwork) {
            BasicNetwork network = (BasicNetwork)method;
            int i = 0;
            while (i < network.getLayerCount() - 1) {
                this.randomize(network, i);
                ++i;
            }
        } else if (method instanceof MLEncodable) {
            MLEncodable encode = (MLEncodable)method;
            double[] encoded = new double[encode.encodedArrayLength()];
            encode.encodeToArray(encoded);
            this.randomize(encoded);
            encode.decodeFromArray(encoded);
        }
    }

    @Override
    public final void setRandom(GenerateRandom theRandom) {
        this.random = theRandom;
    }
}

